/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrModifierListImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrFileStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrMethodStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrModifierListStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrPackageDefinitionStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrTypeDefinitionStub;

public class GrStubUtils {
    private static final Logger LOG = Logger.getInstance(GrStubUtils.class);
    public static final int TOO_LONG = -1;

    public static void writeStringArray(StubOutputStream dataStream, String[] array) throws IOException {
        if (array.length > 127) {
            dataStream.writeByte(-1);
            dataStream.writeInt(array.length);
        } else {
            dataStream.writeByte(array.length);
        }
        for (String s : array) {
            LOG.assertTrue(s != null);
            dataStream.writeName(s);
        }
    }

    public static String[] readStringArray(StubInputStream dataStream) throws IOException {
        int length = dataStream.readByte();
        if (length == -1) {
            length = dataStream.readInt();
        }
        String[] annNames = new String[length];
        for (int i = 0; i < length; ++i) {
            annNames[i] = dataStream.readName().toString();
        }
        return annNames;
    }

    public static void writeNullableString(StubOutputStream dataStream, @Nullable String typeText) throws IOException {
        dataStream.writeBoolean(typeText != null);
        if (typeText != null) {
            dataStream.writeUTFFast(typeText);
        }
    }

    @Nullable
    public static String readNullableString(StubInputStream dataStream) throws IOException {
        boolean hasTypeText = dataStream.readBoolean();
        return hasTypeText ? dataStream.readUTFFast() : null;
    }

    @Nullable
    public static String getTypeText(@Nullable GrTypeElement typeElement) {
        return typeElement == null ? null : typeElement.getText();
    }

    public static String[] getAnnotationNames(PsiModifierListOwner psi) {
        ArrayList annoNames = ContainerUtil.newArrayList();
        PsiModifierList modifierList = psi.getModifierList();
        if (modifierList instanceof GrModifierList) {
            for (GrAnnotation annotation : ((GrModifierList)modifierList).getRawAnnotations()) {
                String name = annotation.getShortName();
                if (!StringUtil.isNotEmpty((String)name)) continue;
                annoNames.add(name);
            }
        }
        return ArrayUtil.toStringArray((Collection)annoNames);
    }

    public static boolean isGroovyStaticMemberStub(StubElement<?> stub) {
        StubElement classStub;
        StubElement modifierOwner = stub instanceof GrMethodStub ? stub : stub.getParentStub();
        StubElement type = modifierOwner.findChildStubByType(GroovyElementTypes.MODIFIERS);
        if (!(type instanceof GrModifierListStub)) {
            return false;
        }
        int mask = ((GrModifierListStub)type).getModifiersFlags();
        if (GrModifierListImpl.hasMaskExplicitModifier("private", mask)) {
            return false;
        }
        if (GrModifierListImpl.hasMaskExplicitModifier("static", mask)) {
            return true;
        }
        StubElement parent = modifierOwner.getParentStub();
        StubElement stubElement = classStub = parent == null ? null : parent.getParentStub();
        return classStub instanceof GrTypeDefinitionStub && (((GrTypeDefinitionStub)classStub).isAnnotationType() || ((GrTypeDefinitionStub)classStub).isInterface());
    }

    @NotNull
    public static String getShortTypeText(@Nullable String text) {
        if (text == null) {
            return "";
        }
        int i = text.length();
        while (i - 2 >= 0 && text.charAt(i - 2) == '[' && text.charAt(i - 1) == ']') {
            i -= 2;
        }
        return PsiNameHelper.getShortClassName((String)text.substring(0, i)) + text.substring(i);
    }

    @Nullable
    public static String getPackageName(GrFileStub stub) {
        for (StubElement child : stub.getChildrenStubs()) {
            if (!(child instanceof GrPackageDefinitionStub)) continue;
            return ((GrPackageDefinitionStub)child).getPackageName();
        }
        return null;
    }
}

