/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.types;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrWildcardTypeArgument;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;

public class GrWildcardTypeArgumentImpl
extends GroovyPsiElementImpl
implements GrWildcardTypeArgument {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.lang.psi.impl.types.GrWildcardTypeArgumentImpl");

    public GrWildcardTypeArgumentImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitWildcardTypeArgument(this);
    }

    public String toString() {
        return "Type argument";
    }

    @Override
    @NotNull
    public PsiType getType() {
        GrTypeElement boundTypeElement = this.getBoundTypeElement();
        if (boundTypeElement == null) {
            return PsiWildcardType.createUnbounded((PsiManager)this.getManager());
        }
        if (this.isExtends()) {
            return PsiWildcardType.createExtends((PsiManager)this.getManager(), (PsiType)boundTypeElement.getType());
        }
        if (this.isSuper()) {
            return PsiWildcardType.createSuper((PsiManager)this.getManager(), (PsiType)boundTypeElement.getType());
        }
        LOG.error("Untested case");
        return null;
    }

    @Override
    public GrTypeElement getBoundTypeElement() {
        return (GrTypeElement)this.findChildByClass(GrTypeElement.class);
    }

    @Override
    public boolean isExtends() {
        return this.findChildByType(GroovyTokenTypes.kEXTENDS) != null;
    }

    @Override
    public boolean isSuper() {
        return this.findChildByType(GroovyTokenTypes.kSUPER) != null;
    }
}

