/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.types;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTraitType;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GrSafeCastExpressionImpl
extends GrExpressionImpl
implements GrSafeCastExpression,
PsiPolyVariantReference {
    private static final Function<GrSafeCastExpressionImpl, PsiType> TYPE_CALCULATOR = new NullableFunction<GrSafeCastExpressionImpl, PsiType>(){

        public PsiType fun(GrSafeCastExpressionImpl cast) {
            PsiType castType;
            GrTypeElement typeElement = cast.getCastTypeElement();
            if (typeElement == null) {
                return null;
            }
            PsiType opType = cast.getOperand().getType();
            if (GrSafeCastExpressionImpl.isCastToRawCollectionFromArray(opType, castType = typeElement.getType())) {
                PsiClass resolved = ((PsiClassType)castType).resolve();
                assert (resolved != null);
                PsiTypeParameter typeParameter = resolved.getTypeParameters()[0];
                HashMap<PsiTypeParameter, PsiType> substitutionMap = new HashMap<PsiTypeParameter, PsiType>();
                substitutionMap.put(typeParameter, TypesUtil.getItemType(opType));
                PsiSubstitutor substitutor = JavaPsiFacade.getElementFactory((Project)cast.getProject()).createSubstitutor(substitutionMap);
                return JavaPsiFacade.getElementFactory((Project)cast.getProject()).createType(resolved, substitutor);
            }
            PsiType traitClassType = GrTraitType.createTraitType(cast);
            if (traitClassType != null) {
                return traitClassType;
            }
            return castType;
        }
    };
    private static final OurResolver OUR_RESOLVER = new OurResolver();

    private static boolean isCastToRawCollectionFromArray(PsiType opType, PsiType castType) {
        return castType instanceof PsiClassType && InheritanceUtil.isInheritor((PsiType)castType, (String)"java.util.Collection") && PsiUtil.extractIterableTypeParameter((PsiType)castType, (boolean)false) == null && ((PsiClassType)castType).resolve().getTypeParameters().length == 1 && TypesUtil.getItemType(opType) != null;
    }

    public GrSafeCastExpressionImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitSafeCastExpression(this);
    }

    public String toString() {
        return "Safe cast expression";
    }

    @Override
    public PsiType getType() {
        return TypeInferenceHelper.getCurrentContext().getExpressionType(this, TYPE_CALCULATOR);
    }

    @Override
    @Nullable
    public GrTypeElement getCastTypeElement() {
        return (GrTypeElement)this.findChildByClass(GrTypeElement.class);
    }

    @Override
    @NotNull
    public GrExpression getOperand() {
        return (GrExpression)this.findNotNullChildByClass(GrExpression.class);
    }

    public PsiReference getReference() {
        return this;
    }

    public PsiElement getElement() {
        return this;
    }

    public TextRange getRangeInElement() {
        PsiElement as = this.findNotNullChildByType(GroovyTokenTypes.kAS);
        int offset = as.getStartOffsetInParent();
        return new TextRange(offset, offset + 2);
    }

    public PsiElement resolve() {
        return PsiImplUtil.extractUniqueResult(this.multiResolve(false)).getElement();
    }

    @NotNull
    public String getCanonicalText() {
        return this.getText();
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        throw new UnsupportedOperationException("safe cast cannot be renamed");
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        throw new UnsupportedOperationException("safe cast can be bounded to nothing");
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.getManager().areElementsEquivalent(this.resolve(), element);
    }

    @NotNull
    public Object[] getVariants() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    @NotNull
    public GroovyResolveResult[] multiResolve(boolean incompleteCode) {
        return TypeInferenceHelper.getCurrentContext().multiResolve(this, incompleteCode, OUR_RESOLVER);
    }

    private static final class OurResolver
    implements ResolveCache.PolyVariantResolver<GrSafeCastExpressionImpl> {
        private OurResolver() {
        }

        @NotNull
        public ResolveResult[] resolve(@NotNull GrSafeCastExpressionImpl cast, boolean incompleteCode) {
            GrExpression operand = cast.getOperand();
            PsiType type = operand.getType();
            if (type == null) {
                return GroovyResolveResult.EMPTY_ARRAY;
            }
            GrTypeElement typeElement = cast.getCastTypeElement();
            PsiType toCast = typeElement == null ? null : typeElement.getType();
            PsiType classType = TypesUtil.createJavaLangClassType(toCast, cast.getProject(), cast.getResolveScope());
            return TypesUtil.getOverloadedOperatorCandidates(type, GroovyTokenTypes.kAS, operand, new PsiType[]{classType});
        }
    }
}

