/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.arithmetic;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GrUnaryExpressionImpl
extends GrExpressionImpl
implements GrUnaryExpression {
    private static final Function<GrUnaryExpressionImpl, PsiType> TYPE_CALCULATOR = new Function<GrUnaryExpressionImpl, PsiType>(){

        @Nullable
        public PsiType fun(GrUnaryExpressionImpl unary) {
            GroovyResolveResult resolveResult = PsiImplUtil.extractUniqueResult(unary.multiResolve(false));
            if (this.isIncDecNumber(resolveResult)) {
                return unary.getOperand().getType();
            }
            PsiType substituted = ResolveUtil.extractReturnTypeFromCandidate(resolveResult, unary, PsiType.EMPTY_ARRAY);
            if (substituted != null) {
                return substituted;
            }
            GrExpression operand = unary.getOperand();
            if (operand == null) {
                return null;
            }
            PsiType type = operand.getType();
            if (TypesUtil.isNumericType(type)) {
                return type;
            }
            return null;
        }

        private boolean isIncDecNumber(GroovyResolveResult result) {
            PsiElement element = result.getElement();
            if (!(element instanceof PsiMethod)) {
                return false;
            }
            PsiMethod method = element instanceof GrGdkMethod ? ((GrGdkMethod)element).getStaticMethod() : (PsiMethod)element;
            String name = method.getName();
            if (!"next".equals(name) && !"previous".equals(name)) {
                return false;
            }
            if (!PsiUtil.isDGMMethod((PsiElement)method)) {
                return false;
            }
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (parameters.length != 1) {
                return false;
            }
            return parameters[0].getType().equalsToText("java.lang.Number");
        }
    };
    private static final ResolveCache.PolyVariantResolver<GrUnaryExpressionImpl> OUR_RESOLVER = new ResolveCache.PolyVariantResolver<GrUnaryExpressionImpl>(){

        @NotNull
        public GroovyResolveResult[] resolve(@NotNull GrUnaryExpressionImpl unary, boolean incompleteCode) {
            GrExpression operand = unary.getOperand();
            if (operand == null) {
                return GroovyResolveResult.EMPTY_ARRAY;
            }
            PsiType type = operand.getType();
            if (type == null) {
                return GroovyResolveResult.EMPTY_ARRAY;
            }
            return TypesUtil.getOverloadedUnaryOperatorCandidates(type, unary.getOperationTokenType(), operand, PsiType.EMPTY_ARRAY);
        }
    };

    public GrUnaryExpressionImpl(@NotNull ASTNode node) {
        super(node);
    }

    public String toString() {
        return "Unary expression";
    }

    @Override
    public PsiType getType() {
        return TypeInferenceHelper.getCurrentContext().getExpressionType(this, TYPE_CALCULATOR);
    }

    @Override
    @NotNull
    public IElementType getOperationTokenType() {
        PsiElement opElement = this.getOperationToken();
        ASTNode node = opElement.getNode();
        assert (node != null);
        return node.getElementType();
    }

    @Override
    @NotNull
    public PsiElement getOperationToken() {
        PsiElement opElement = this.findChildByType(TokenSets.UNARY_OP_SET);
        assert (opElement != null);
        return opElement;
    }

    @Override
    public GrExpression getOperand() {
        return GrUnaryExpressionImpl.findExpressionChild(this);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitUnaryExpression(this);
    }

    @Override
    @NotNull
    public GroovyResolveResult[] multiResolve(boolean incompleteCode) {
        return TypeInferenceHelper.getCurrentContext().multiResolve(this, incompleteCode, OUR_RESOLVER);
    }

    @Override
    public boolean isPostfix() {
        return this.getFirstChild() instanceof GrExpression;
    }

    public PsiElement getElement() {
        return this;
    }

    public TextRange getRangeInElement() {
        PsiElement opToken = this.getOperationToken();
        int offset = opToken.getStartOffsetInParent();
        return new TextRange(offset, offset + opToken.getTextLength());
    }

    public PsiElement resolve() {
        return PsiImplUtil.extractUniqueElement(this.multiResolve(false));
    }

    @NotNull
    public String getCanonicalText() {
        return this.getText();
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        throw new IncorrectOperationException("unary expression cannot be renamed to anything");
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        throw new IncorrectOperationException("unary expression cannot be bounded to anything");
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.getManager().areElementsEquivalent(this.resolve(), element);
    }

    @NotNull
    public Object[] getVariants() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }

    public PsiReference getReference() {
        return this;
    }
}

