/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrReferenceExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.path.GrCallExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrCallExpressionTypeCalculator;

public abstract class GrMethodCallImpl
extends GrCallExpressionImpl
implements GrMethodCall {
    private static final Function<GrMethodCall, PsiType> METHOD_CALL_TYPES_CALCULATOR = new Function<GrMethodCall, PsiType>(){

        @Nullable
        public PsiType fun(GrMethodCall callExpression) {
            GrExpression invokedExpression = callExpression.getInvokedExpression();
            GroovyResolveResult[] resolveResults = invokedExpression instanceof GrReferenceExpression ? ((GrReferenceExpression)invokedExpression).multiResolve(false) : GroovyResolveResult.EMPTY_ARRAY;
            for (GrCallExpressionTypeCalculator typeCalculator : (GrCallExpressionTypeCalculator[])GrCallExpressionTypeCalculator.EP_NAME.getExtensions()) {
                PsiType res = typeCalculator.calculateReturnType(callExpression, resolveResults);
                if (res == null) continue;
                return res;
            }
            return null;
        }
    };

    public GrMethodCallImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public GroovyResolveResult[] getCallVariants(@Nullable GrExpression upToArgument) {
        GrExpression invoked = this.getInvokedExpression();
        if (!(invoked instanceof GrReferenceExpressionImpl)) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        return ((GrReferenceExpressionImpl)invoked).getCallVariants(upToArgument);
    }

    @Override
    @NotNull
    public GrExpression getInvokedExpression() {
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!(cur instanceof GrExpression)) continue;
            return (GrExpression)cur;
        }
        throw new IncorrectOperationException("invoked expression must not be null");
    }

    @Override
    public PsiMethod resolveMethod() {
        GrExpression methodExpr = this.getInvokedExpression();
        if (methodExpr instanceof GrReferenceExpression) {
            PsiElement resolved = ((GrReferenceExpression)methodExpr).resolve();
            return resolved instanceof PsiMethod ? (PsiMethod)resolved : null;
        }
        return null;
    }

    @Override
    @NotNull
    public GroovyResolveResult advancedResolve() {
        GrExpression methodExpr = this.getInvokedExpression();
        if (methodExpr instanceof GrReferenceExpression) {
            return ((GrReferenceExpression)methodExpr).advancedResolve();
        }
        return GroovyResolveResult.EMPTY_RESULT;
    }

    @Override
    public PsiType getType() {
        return TypeInferenceHelper.getCurrentContext().getExpressionType(this, METHOD_CALL_TYPES_CALCULATOR);
    }

    @Override
    public boolean isCommandExpression() {
        GrExpression expression = this.getInvokedExpression();
        if (!(expression instanceof GrReferenceExpression) || ((GrReferenceExpression)expression).getQualifier() == null) {
            return false;
        }
        return ((GrReferenceExpression)expression).getDotToken() == null;
    }

    @Override
    @NotNull
    public GroovyResolveResult[] multiResolve(boolean incompleteCode) {
        GrExpression expression = this.getInvokedExpression();
        if (!(expression instanceof GrReferenceExpression)) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        return ((GrReferenceExpression)expression).multiResolve(incompleteCode);
    }

    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }
}

