/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrIfStatementImpl
extends GroovyPsiElementImpl
implements GrIfStatement {
    public GrIfStatementImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitIfStatement(this);
    }

    public String toString() {
        return "IF statement";
    }

    @Override
    @Nullable
    public GrExpression getCondition() {
        PsiElement lParenth = this.getLParenth();
        if (lParenth == null) {
            return null;
        }
        PsiElement afterLParenth = PsiUtil.skipWhitespacesAndComments(lParenth.getNextSibling(), true);
        if (afterLParenth instanceof GrExpression) {
            return (GrExpression)afterLParenth;
        }
        return null;
    }

    @Override
    @Nullable
    public GrStatement getThenBranch() {
        ArrayList<GrStatement> statements = new ArrayList<GrStatement>();
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!GrStatement.class.isInstance(cur)) continue;
            statements.add((GrStatement)cur);
        }
        if (this.getCondition() == null && !statements.isEmpty()) {
            return (GrStatement)statements.get(0);
        }
        if (statements.size() > 1) {
            return (GrStatement)statements.get(1);
        }
        return null;
    }

    @Override
    @Nullable
    public GrStatement getElseBranch() {
        ArrayList<GrStatement> statements = new ArrayList<GrStatement>();
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!(cur instanceof GrStatement)) continue;
            statements.add((GrStatement)cur);
        }
        if (statements.size() == 3) {
            return (GrStatement)statements.get(2);
        }
        return null;
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        PsiElement elseKeywordElement;
        GrStatement elseBranch = this.getElseBranch();
        if (elseBranch != null && child == elseBranch.getNode() && (elseKeywordElement = this.findChildByType(GroovyTokenTypes.kELSE)) != null) {
            super.deleteChildInternal(elseKeywordElement.getNode());
        }
        super.deleteChildInternal(child);
    }

    @Override
    @NotNull
    public <T extends GrStatement> T replaceThenBranch(@NotNull T newBranch) throws IncorrectOperationException {
        return PsiImplUtil.replaceBody(newBranch, this.getThenBranch(), this.getNode(), this.getProject());
    }

    @Override
    @NotNull
    public <T extends GrStatement> T replaceElseBranch(@NotNull T newBranch) throws IncorrectOperationException {
        return PsiImplUtil.replaceBody(newBranch, this.getElseBranch(), this.getNode(), this.getProject());
    }

    @Override
    public PsiElement getElseKeyword() {
        return this.findChildByType(GroovyTokenTypes.kELSE);
    }

    @Override
    public PsiElement getRParenth() {
        return this.findChildByType(GroovyTokenTypes.mRPAREN);
    }

    @Override
    public PsiElement getLParenth() {
        return this.findChildByType(GroovyTokenTypes.mLPAREN);
    }
}

