/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GrCatchClauseImpl
extends GroovyPsiElementImpl
implements GrCatchClause {
    public GrCatchClauseImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitCatchClause(this);
    }

    public String toString() {
        return "Catch clause";
    }

    @Override
    @Nullable
    public GrParameter getParameter() {
        return (GrParameter)this.findChildByClass(GrParameter.class);
    }

    @Override
    public GrOpenBlock getBody() {
        return (GrOpenBlock)this.findChildByClass(GrOpenBlock.class);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (!ResolveUtil.shouldProcessProperties((ElementClassHint)processor.getHint(ElementClassHint.KEY))) {
            return true;
        }
        GrParameter parameter = this.getParameter();
        return parameter == null || ResolveUtil.processElement(processor, parameter, state);
    }

    @Override
    public GrParameter[] getParameters() {
        GrParameter[] grParameterArray;
        GrParameter parameter = this.getParameter();
        if (parameter != null) {
            GrParameter[] grParameterArray2 = new GrParameter[1];
            grParameterArray = grParameterArray2;
            grParameterArray2[0] = parameter;
        } else {
            grParameterArray = GrParameter.EMPTY_ARRAY;
        }
        return grParameterArray;
    }

    @Override
    public GrParameterList getParameterList() {
        return null;
    }

    @Override
    public boolean isVarArgs() {
        throw new IncorrectOperationException("Catch clause cannot have varargs");
    }

    @Override
    public PsiElement getRParenth() {
        return this.findChildByType(GroovyTokenTypes.mRPAREN);
    }

    @Override
    public PsiElement getLBrace() {
        return this.findChildByType(GroovyTokenTypes.mLCURLY);
    }
}

