/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.signatures;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.PsiSubstitutorImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrMultiSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrRecursiveSignatureVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.LazyFqnClassType;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosableSignatureImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosableSignatureWithErasedParameters;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureWithNewParameters;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrDelegatingClosureParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrImmediateClosureParameterImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrImmediateClosureSignatureImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrMethodSignatureImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrMethodSignatureWithErasedTypes;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrMultiSignatureImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrClosureSignatureUtil {
    private static final Logger LOG = Logger.getInstance(GrClosureSignatureUtil.class);

    private GrClosureSignatureUtil() {
    }

    public static GrMultiSignature createMultiSignature(GrClosureSignature[] signatures) {
        return new GrMultiSignatureImpl(signatures);
    }

    @Nullable
    public static GrClosureSignature createSignature(GrCall call) {
        GrExpression invokedExpression;
        PsiType type;
        if (call instanceof GrMethodCall && (type = (invokedExpression = ((GrMethodCall)call).getInvokedExpression()).getType()) instanceof GrClosureType) {
            GrSignature signature = ((GrClosureType)type).getSignature();
            Trinity<GrClosureSignature, ArgInfo<PsiType>[], ApplicabilityResult> trinity = GrClosureSignatureUtil.getApplicableSignature(signature, PsiUtil.getArgumentTypes(invokedExpression, true), call);
            if (trinity != null) {
                return (GrClosureSignature)trinity.first;
            }
            return null;
        }
        GroovyResolveResult resolveResult = call.advancedResolve();
        PsiElement element = resolveResult.getElement();
        if (element instanceof PsiMethod) {
            return GrClosureSignatureUtil.createSignature((PsiMethod)element, resolveResult.getSubstitutor());
        }
        return null;
    }

    public static GrClosureSignature createSignature(MethodSignature signature) {
        Object[] types = signature.getParameterTypes();
        Object[] parameters = new GrClosureParameter[types.length];
        ContainerUtil.map((Object[])types, (Function)new Function<PsiType, GrClosureParameter>(){

            public GrClosureParameter fun(PsiType type) {
                return new GrImmediateClosureParameterImpl(type, null, false, null);
            }
        }, (Object[])parameters);
        return new GrImmediateClosureSignatureImpl((GrClosureParameter[])parameters, null, false, false);
    }

    @NotNull
    public static GrClosureSignature createSignature(GrClosableBlock block) {
        return new GrClosableSignatureImpl(block);
    }

    public static GrClosureSignature createSignature(PsiMethod method, PsiSubstitutor substitutor) {
        return new GrMethodSignatureImpl(method, substitutor);
    }

    public static GrClosureSignature removeParam(GrClosureSignature signature, int i) {
        GrClosureParameter[] newParams = (GrClosureParameter[])ArrayUtil.remove((Object[])signature.getParameters(), (int)i);
        return new GrClosureSignatureWithNewParameters(signature, newParams);
    }

    public static GrClosureSignature createSignatureWithErasedParameterTypes(PsiMethod method) {
        return new GrMethodSignatureWithErasedTypes(method);
    }

    @NotNull
    public static GrClosureSignature createSignatureWithErasedParameterTypes(GrClosableBlock closure) {
        return new GrClosableSignatureWithErasedParameters(closure);
    }

    @NotNull
    public static GrClosureSignature rawSignature(@NotNull GrClosureSignature signature) {
        Object[] params = signature.getParameters();
        GrClosureParameter[] closureParams = (GrClosureParameter[])ContainerUtil.map((Object[])params, (Function)new Function<GrClosureParameter, GrClosureParameter>(){

            public GrClosureParameter fun(GrClosureParameter parameter) {
                PsiType type = TypeConversionUtil.erasure((PsiType)parameter.getType());
                return new GrImmediateClosureParameterImpl(type, parameter.getName(), parameter.isOptional(), parameter.getDefaultInitializer());
            }
        }, (Object[])new GrClosureParameter[params.length]);
        return new GrClosureSignatureWithNewParameters(signature, closureParams);
    }

    public static GrClosureSignature createSignature(PsiParameter[] parameters, @Nullable PsiType returnType) {
        return new GrImmediateClosureSignatureImpl(parameters, returnType);
    }

    @Nullable
    public static PsiType getReturnType(@NotNull GrSignature signature, @NotNull GrMethodCall expr) {
        return GrClosureSignatureUtil.getReturnType(signature, PsiUtil.getArgumentTypes(expr.getInvokedExpression(), true), expr);
    }

    @Nullable
    public static PsiType getReturnType(final @NotNull GrSignature signature, @Nullable PsiType[] args, @NotNull GroovyPsiElement context) {
        if (signature instanceof GrClosureSignature) {
            return ((GrClosureSignature)signature).getReturnType();
        }
        if (args == null) {
            return TypesUtil.getLeastUpperBoundNullable(new Iterable<PsiType>(){

                @Override
                public Iterator<PsiType> iterator() {
                    return new Iterator<PsiType>(){
                        private final Iterator<GrClosureSignature> it;
                        {
                            this.it = Arrays.asList(((GrMultiSignature)signature).getAllSignatures()).iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.it.hasNext();
                        }

                        @Override
                        public PsiType next() {
                            return this.it.next().getReturnType();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            }, context.getManager());
        }
        final List<Trinity<GrClosureSignature, ArgInfo<PsiType>[], ApplicabilityResult>> results = GrClosureSignatureUtil.getSignatureApplicabilities(signature, args, context);
        if (results.size() == 1) {
            return ((GrClosureSignature)results.get((int)0).first).getReturnType();
        }
        return TypesUtil.getLeastUpperBoundNullable(new Iterable<PsiType>(){

            @Override
            public Iterator<PsiType> iterator() {
                return new Iterator<PsiType>(){
                    private final Iterator<Trinity<GrClosureSignature, ArgInfo<PsiType>[], ApplicabilityResult>> myIterator;
                    {
                        this.myIterator = results.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.myIterator.hasNext();
                    }

                    @Override
                    @Nullable
                    public PsiType next() {
                        return ((GrClosureSignature)this.myIterator.next().first).getReturnType();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }, context.getManager());
    }

    public static boolean isSignatureApplicable(@NotNull GrSignature signature, @NotNull PsiType[] args, @NotNull PsiElement context) {
        return GrClosureSignatureUtil.isSignatureApplicableConcrete(signature, args, context) != ApplicabilityResult.inapplicable;
    }

    public static ApplicabilityResult isSignatureApplicableConcrete(@NotNull GrSignature signature, @NotNull PsiType[] args, @NotNull PsiElement context) {
        List<Trinity<GrClosureSignature, ArgInfo<PsiType>[], ApplicabilityResult>> results = GrClosureSignatureUtil.getSignatureApplicabilities(signature, args, context);
        if (results.isEmpty()) {
            return ApplicabilityResult.inapplicable;
        }
        if (results.size() == 1) {
            return (ApplicabilityResult)((Object)results.get((int)0).third);
        }
        return ApplicabilityResult.ambiguous;
    }

    @Nullable
    public static Trinity<GrClosureSignature, ArgInfo<PsiType>[], ApplicabilityResult> getApplicableSignature(@NotNull GrSignature signature, @Nullable PsiType[] args, @NotNull GroovyPsiElement context) {
        if (args == null) {
            return null;
        }
        List<Trinity<GrClosureSignature, ArgInfo<PsiType>[], ApplicabilityResult>> results = GrClosureSignatureUtil.getSignatureApplicabilities(signature, args, context);
        if (results.size() == 1) {
            return results.get(0);
        }
        return null;
    }

    private static List<Trinity<GrClosureSignature, ArgInfo<PsiType>[], ApplicabilityResult>> getSignatureApplicabilities(@NotNull GrSignature signature, final @NotNull PsiType[] args, final @NotNull PsiElement context) {
        final ArrayList<Trinity<GrClosureSignature, ArgInfo<PsiType>[], ApplicabilityResult>> results = new ArrayList<Trinity<GrClosureSignature, ArgInfo<PsiType>[], ApplicabilityResult>>();
        signature.accept(new GrRecursiveSignatureVisitor(){

            @Override
            public void visitClosureSignature(GrClosureSignature signature) {
                ArgInfo[] map = GrClosureSignatureUtil.mapArgTypesToParameters(signature, args, context, false);
                if (map != null) {
                    results.add(new Trinity((Object)signature, (Object)map, (Object)GrClosureSignatureUtil.isSignatureApplicableInner(map, signature)));
                    return;
                }
                if (args.length == 1 && PsiUtil.isInMethodCallContext(context)) {
                    PsiType[] _args;
                    GrClosureParameter[] parameters = signature.getParameters();
                    if (parameters.length == 1 && parameters[0].getType() instanceof PsiArrayType) {
                        return;
                    }
                    PsiType arg = args[0];
                    if (arg instanceof GrTupleType && (map = GrClosureSignatureUtil.mapArgTypesToParameters(signature, _args = ((GrTupleType)arg).getComponentTypes(), context, false)) != null) {
                        results.add(new Trinity((Object)signature, (Object)map, (Object)GrClosureSignatureUtil.isSignatureApplicableInner(map, signature)));
                    }
                }
            }
        });
        return results;
    }

    private static ApplicabilityResult isSignatureApplicableInner(@NotNull ArgInfo<PsiType>[] infos, @NotNull GrClosureSignature signature) {
        GrClosureParameter[] parameters = signature.getParameters();
        for (int i = 0; i < infos.length; ++i) {
            PsiType pType;
            PsiType type;
            ArgInfo<PsiType> info = infos[i];
            if (info.args.size() != 1 || info.isMultiArg || (type = (PsiType)info.args.get(0)) != null || (pType = parameters[i].getType()) == null || pType.equalsToText("java.lang.Object")) continue;
            return ApplicabilityResult.canBeApplicable;
        }
        return ApplicabilityResult.applicable;
    }

    static GrSignature curryImpl(GrClosureSignature original, PsiType[] args, int position, PsiElement context) {
        GrClosureParameter[] params = original.getParameters();
        ArrayList<GrClosureParameter> newParams = new ArrayList<GrClosureParameter>(params.length);
        ArrayList<GrClosureParameter> opts = new ArrayList<GrClosureParameter>(params.length);
        ArrayList<Integer> optInds = new ArrayList<Integer>(params.length);
        if (position == -1) {
            position = params.length - args.length;
        }
        if (position < 0 || position >= params.length) {
            return GrMultiSignature.EMPTY_SIGNATURE;
        }
        for (int i = 0; i < params.length; ++i) {
            if (params[i].isOptional()) {
                opts.add(params[i]);
                optInds.add(i);
                continue;
            }
            newParams.add(params[i]);
        }
        PsiType rtype = original.getReturnType();
        ArrayList<GrClosureSignature> result = new ArrayList<GrClosureSignature>();
        GrClosureSignatureUtil.checkAndAddSignature(result, args, position, newParams, rtype, context);
        for (int i = 0; i < opts.size(); ++i) {
            newParams.add((Integer)optInds.get(i), (GrClosureParameter)opts.get(i));
            GrClosureSignatureUtil.checkAndAddSignature(result, args, position, newParams, rtype, context);
        }
        if (result.size() == 1) {
            return result.get(0);
        }
        return new GrMultiSignatureImpl(result.toArray(new GrClosureSignature[result.size()]));
    }

    public static boolean isVarArgsImpl(@NotNull GrClosureParameter[] parameters) {
        return parameters.length > 0 && parameters[parameters.length - 1].getType() instanceof PsiArrayType;
    }

    @Nullable
    public static ArgInfo<PsiType>[] mapArgTypesToParameters(@NotNull GrClosureSignature signature, @NotNull PsiType[] args, @NotNull PsiElement context, boolean partial) {
        return GrClosureSignatureUtil.mapParametersToArguments(signature, args, FunctionUtil.id(), context, partial);
    }

    private static <Arg> Function<ArgWrapper<Arg>, PsiType> ARG_WRAPPER_COMPUTER() {
        return new Function<ArgWrapper<Arg>, PsiType>(){

            public PsiType fun(ArgWrapper<Arg> argWrapper) {
                return argWrapper.type;
            }
        };
    }

    @Nullable
    private static <Arg> ArgInfo<Arg>[] mapParametersToArguments(@NotNull GrClosureSignature signature, @NotNull Arg[] args, @NotNull Function<Arg, PsiType> typeComputer, @NotNull PsiElement context, boolean partial) {
        LOG.assertTrue(signature.isValid(), signature.getClass());
        if (GrClosureSignatureUtil.checkForOnlyMapParam(signature, args.length)) {
            return ArgInfo.empty_array();
        }
        GrClosureParameter[] params = signature.getParameters();
        if (args.length > params.length && !signature.isVarargs() && !partial) {
            return null;
        }
        int optional = GrClosureSignatureUtil.getOptionalParamCount(signature, false);
        int notOptional = params.length - optional;
        if (signature.isVarargs()) {
            --notOptional;
        }
        if (notOptional > args.length && !partial) {
            return null;
        }
        ArgInfo<Arg>[] map = GrClosureSignatureUtil.mapSimple(params, args, typeComputer, context, false);
        if (map != null) {
            return map;
        }
        if (signature.isVarargs()) {
            return new ParameterMapperForVararg(context, params, args, typeComputer).isApplicable();
        }
        if (!partial) {
            return null;
        }
        return GrClosureSignatureUtil.mapSimple(params, args, typeComputer, context, true);
    }

    private static boolean checkForOnlyMapParam(@NotNull GrClosureSignature signature, int argCount) {
        if (argCount > 0 || signature.isCurried()) {
            return false;
        }
        GrClosureParameter[] parameters = signature.getParameters();
        if (parameters.length != 1) {
            return false;
        }
        PsiType type = parameters[0].getType();
        return InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Map");
    }

    @Nullable
    private static <Arg> ArgInfo<Arg>[] mapSimple(@NotNull GrClosureParameter[] params, @NotNull Arg[] args, @NotNull Function<Arg, PsiType> typeComputer, @NotNull PsiElement context, boolean partial) {
        if (args.length > params.length && !partial) {
            return null;
        }
        ArgInfo[] map = new ArgInfo[params.length];
        int optional = GrClosureSignatureUtil.getOptionalParamCount(params, false);
        int notOptional = params.length - optional;
        int optionalArgs = args.length - notOptional;
        if (notOptional > args.length && !partial) {
            return null;
        }
        int cur = 0;
        int i = 0;
        while (i < args.length) {
            while (optionalArgs == 0 && cur < params.length && params[cur].isOptional()) {
                ++cur;
            }
            if (cur == params.length) {
                return partial ? map : null;
            }
            if (params[cur].isOptional()) {
                --optionalArgs;
            }
            PsiType type = (PsiType)typeComputer.fun(args[i]);
            if (!GrClosureSignatureUtil.isAssignableByConversion(params[cur].getType(), type, context)) {
                return partial ? map : null;
            }
            map[cur] = new ArgInfo<Arg>(args[i], type);
            ++i;
            ++cur;
        }
        for (i = 0; i < map.length; ++i) {
            if (map[i] != null) continue;
            map[i] = new ArgInfo(Collections.emptyList(), false, null);
        }
        return map;
    }

    private static boolean isAssignableByConversion(@Nullable PsiType paramType, @Nullable PsiType argType, @NotNull PsiElement context) {
        if (argType == null || paramType == null) {
            return true;
        }
        if (TypesUtil.isAssignableByMethodCallConversion(paramType, argType, context)) {
            return true;
        }
        PsiType lType = TypesUtil.rawSecondGeneric(paramType, context.getProject());
        PsiType rType = TypesUtil.rawSecondGeneric(argType, context.getProject());
        if (lType == null && rType == null) {
            return false;
        }
        return TypesUtil.isAssignableByMethodCallConversion(lType != null ? lType : paramType, rType != null ? rType : argType, context);
    }

    public static void checkAndAddSignature(List<GrClosureSignature> list, PsiType[] args, int position, List<GrClosureParameter> params, PsiType returnType, @NotNull PsiElement context) {
        int i;
        int last = position + args.length;
        if (last > params.size()) {
            return;
        }
        for (int i2 = position; i2 < last; ++i2) {
            GrClosureParameter p = params.get(i2);
            PsiType type = p.getType();
            if (GrClosureSignatureUtil.isAssignableByConversion(type, args[i2 - position], context)) continue;
            return;
        }
        GrClosureParameter[] _p = new GrClosureParameter[params.size() - args.length];
        int j = 0;
        for (i = 0; i < position; ++i) {
            _p[j++] = params.get(i);
        }
        for (i = position + args.length; i < params.size(); ++i) {
            _p[j++] = params.get(i);
        }
        list.add(new GrImmediateClosureSignatureImpl(_p, returnType, _p.length > 0 && _p[_p.length - 1].getType() instanceof PsiArrayType, true));
    }

    @Nullable
    public static GrClosureSignature createSignature(GroovyResolveResult resolveResult) {
        PsiElement resolved = resolveResult.getElement();
        if (!(resolved instanceof PsiMethod)) {
            return null;
        }
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        return GrClosureSignatureUtil.createSignature((PsiMethod)resolved, substitutor);
    }

    public static int getOptionalParamCount(GrClosureSignature signature, boolean hasNamedArgs) {
        return GrClosureSignatureUtil.getOptionalParamCount(signature.getParameters(), hasNamedArgs);
    }

    public static int getOptionalParamCount(GrClosureParameter[] parameters, boolean hasNamedArgs) {
        int count = 0;
        int i = 0;
        if (hasNamedArgs) {
            ++i;
        }
        while (i < parameters.length) {
            GrClosureParameter parameter = parameters[i];
            if (parameter.isOptional()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    @Nullable
    public static Map<GrExpression, Pair<PsiParameter, PsiType>> mapArgumentsToParameters(@NotNull GroovyResolveResult resolveResult, @NotNull PsiElement context, boolean partial, boolean eraseArgs, @NotNull GrNamedArgument[] namedArgs, @NotNull GrExpression[] expressionArgs, @NotNull GrClosableBlock[] closureArguments) {
        PsiParameter[] parameters;
        GrClosureSignature signature;
        PsiElement element = resolveResult.getElement();
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        if (element instanceof PsiMethod) {
            signature = eraseArgs ? GrClosureSignatureUtil.createSignatureWithErasedParameterTypes((PsiMethod)element) : GrClosureSignatureUtil.createSignature((PsiMethod)element, substitutor);
            parameters = ((PsiMethod)element).getParameterList().getParameters();
        } else if (element instanceof GrClosableBlock) {
            signature = eraseArgs ? GrClosureSignatureUtil.createSignatureWithErasedParameterTypes((GrClosableBlock)element) : GrClosureSignatureUtil.createSignature((GrClosableBlock)element);
            parameters = ((GrClosableBlock)element).getAllParameters();
        } else {
            return null;
        }
        ArgInfo<PsiElement>[] argInfos = GrClosureSignatureUtil.mapParametersToArguments(signature, namedArgs, expressionArgs, closureArguments, context, partial, eraseArgs);
        if (argInfos == null) {
            return null;
        }
        HashMap<GrExpression, Pair<PsiParameter, PsiType>> result = new HashMap<GrExpression, Pair<PsiParameter, PsiType>>();
        for (int i = 0; i < argInfos.length; ++i) {
            ArgInfo<PsiElement> info = argInfos[i];
            if (info == null) continue;
            for (PsiElement arg : info.args) {
                if (arg instanceof GrNamedArgument) {
                    arg = ((GrNamedArgument)arg).getExpression();
                }
                GrExpression expression = (GrExpression)arg;
                PsiType type = parameters[i].getType();
                if (info.isMultiArg && type instanceof PsiArrayType) {
                    type = ((PsiArrayType)type).getComponentType();
                }
                result.put(expression, (Pair<PsiParameter, PsiType>)Pair.create((Object)parameters[i], (Object)substitutor.substitute(type)));
            }
        }
        return result;
    }

    @Nullable
    public static ArgInfo<PsiElement>[] mapParametersToArguments(@NotNull GrClosureSignature signature, @NotNull GrCall call) {
        return GrClosureSignatureUtil.mapParametersToArguments(signature, call.getNamedArguments(), call.getExpressionArguments(), call.getClosureArguments(), call, false, false);
    }

    @Nullable
    public static ArgInfo<PsiElement>[] mapParametersToArguments(@NotNull GrClosureSignature signature, @NotNull GrNamedArgument[] namedArgs, @NotNull GrExpression[] expressionArgs, @NotNull GrClosableBlock[] closureArguments, @NotNull PsiElement context, boolean partial, boolean eraseArgs) {
        ArrayList<InnerArg> innerArgs = new ArrayList<InnerArg>();
        boolean hasNamedArgs = namedArgs.length > 0;
        GrClosureParameter[] params = signature.getParameters();
        if (hasNamedArgs) {
            if (params.length == 0) {
                return null;
            }
            PsiType type = params[0].getType();
            if (InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Map") || type == null || type.equalsToText("java.lang.Object")) {
                innerArgs.add(new InnerArg((PsiType)GrMapType.create(context.getResolveScope()), namedArgs));
            } else {
                return null;
            }
        }
        for (GrExpression grExpression : expressionArgs) {
            PsiType type = grExpression.getType();
            if (partial && grExpression instanceof GrNewExpression && com.intellij.psi.util.PsiUtil.resolveClassInType((PsiType)type) == null) {
                type = null;
            }
            if (eraseArgs) {
                type = TypeConversionUtil.erasure((PsiType)type);
            }
            innerArgs.add(new InnerArg(type, grExpression));
        }
        for (GrExpression grExpression : closureArguments) {
            innerArgs.add(new InnerArg(TypeConversionUtil.erasure((PsiType)grExpression.getType()), grExpression));
        }
        return GrClosureSignatureUtil.mapParametersToArguments(signature, innerArgs, hasNamedArgs, partial, context);
    }

    private static ArgInfo<PsiElement>[] mapParametersToArguments(@NotNull GrClosureSignature signature, @NotNull List<InnerArg> innerArgs, boolean hasNamedArgs, boolean partial, @NotNull PsiElement context) {
        ArgInfo<InnerArg>[] innerMap = GrClosureSignatureUtil.mapParametersToArguments(signature, innerArgs.toArray(new InnerArg[innerArgs.size()]), new Function<InnerArg, PsiType>(){

            public PsiType fun(InnerArg o) {
                return o.type;
            }
        }, context, partial);
        if (innerMap == null) {
            return null;
        }
        ArgInfo[] map = new ArgInfo[innerMap.length];
        int i = 0;
        if (hasNamedArgs) {
            map[i] = new ArgInfo<PsiElement>(((InnerArg)innerMap[i].args.iterator().next()).list, true, innerArgs.get((int)i).type);
            ++i;
        }
        while (i < innerMap.length) {
            ArgInfo<InnerArg> innerArg = innerMap[i];
            if (innerArg == null) {
                map[i] = null;
            } else {
                ArrayList<PsiElement> argList = new ArrayList<PsiElement>();
                for (InnerArg arg : innerArg.args) {
                    argList.addAll(arg.list);
                }
                boolean multiArg = innerArg.isMultiArg || argList.size() > 1;
                map[i] = new ArgInfo(argList, multiArg, innerArg.type);
            }
            ++i;
        }
        return map;
    }

    public static List<MethodSignature> generateAllSignaturesForMethod(GrMethod method, PsiSubstitutor substitutor) {
        GrClosureSignature signature = GrClosureSignatureUtil.createSignature(method, substitutor);
        String name = method.getName();
        PsiTypeParameter[] typeParameters = method.getTypeParameters();
        ArrayList<MethodSignature> result = new ArrayList<MethodSignature>();
        GrClosureSignatureUtil.generateAllMethodSignaturesByClosureSignature(name, signature, typeParameters, substitutor, result);
        return result;
    }

    @NotNull
    public static MultiMap<MethodSignature, PsiMethod> findRawMethodSignatures(@NotNull PsiMethod[] methods, @NotNull PsiClass clazz) {
        HashMap initialMap = ContainerUtil.newHashMap();
        for (PsiTypeParameter parameter : clazz.getTypeParameters()) {
            initialMap.put(parameter, null);
        }
        PsiSubstitutor initialSubstitutor = PsiSubstitutorImpl.createSubstitutor((Map)initialMap);
        MultiMap result = new MultiMap();
        for (PsiMethod method : methods) {
            PsiMethod actual = method instanceof GrReflectedMethod ? ((GrReflectedMethod)method).getBaseMethod() : method;
            PsiSubstitutor substitutor = GrClosureSignatureUtil.calcRawSubstitutor(initialMap, initialSubstitutor, actual);
            result.putValue((Object)method.getSignature(substitutor), (Object)actual);
        }
        return result;
    }

    @NotNull
    private static PsiSubstitutor calcRawSubstitutor(@NotNull Map<PsiTypeParameter, PsiType> initialMap, @NotNull PsiSubstitutor initialSubstitutor, @NotNull PsiMethod actual) {
        if (actual.hasTypeParameters()) {
            HashMap map1 = ContainerUtil.newHashMap(initialMap);
            for (PsiTypeParameter parameter : actual.getTypeParameters()) {
                map1.put(parameter, null);
            }
            return PsiSubstitutorImpl.createSubstitutor((Map)map1);
        }
        return initialSubstitutor;
    }

    private static MethodSignature generateSignature(String name, List<PsiType> paramTypes, PsiTypeParameter[] typeParameters, PsiSubstitutor substitutor) {
        return MethodSignatureUtil.createMethodSignature((String)name, (PsiType[])paramTypes.toArray(PsiType.createArray((int)paramTypes.size())), (PsiTypeParameter[])typeParameters, (PsiSubstitutor)substitutor);
    }

    public static void generateAllMethodSignaturesByClosureSignature(@NotNull String name, @NotNull GrClosureSignature signature, @NotNull PsiTypeParameter[] typeParameters, @NotNull PsiSubstitutor substitutor, List<MethodSignature> result) {
        int i;
        GrClosureParameter[] params = signature.getParameters();
        ArrayList<PsiType> newParams = new ArrayList<PsiType>(params.length);
        ArrayList<GrClosureParameter> opts = new ArrayList<GrClosureParameter>(params.length);
        ArrayList<Integer> optInds = new ArrayList<Integer>(params.length);
        for (i = 0; i < params.length; ++i) {
            if (params[i].isOptional()) {
                opts.add(params[i]);
                optInds.add(i);
                continue;
            }
            newParams.add(params[i].getType());
        }
        result.add(GrClosureSignatureUtil.generateSignature(name, newParams, typeParameters, substitutor));
        for (i = 0; i < opts.size(); ++i) {
            newParams.add((Integer)optInds.get(i), ((GrClosureParameter)opts.get(i)).getType());
            result.add(GrClosureSignatureUtil.generateSignature(name, newParams, typeParameters, substitutor));
        }
    }

    public static List<MethodSignature> generateAllMethodSignaturesBySignature(final @NotNull String name, @NotNull GrSignature signature) {
        final ArrayList<MethodSignature> result = new ArrayList<MethodSignature>();
        signature.accept(new GrRecursiveSignatureVisitor(){

            @Override
            public void visitClosureSignature(GrClosureSignature signature) {
                GrClosureSignatureUtil.generateAllMethodSignaturesByClosureSignature(name, signature, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY, result);
            }
        });
        return result;
    }

    @Nullable
    public static PsiType getTypeByArg(ArgInfo<PsiElement> arg, PsiManager manager, GlobalSearchScope resolveScope) {
        if (arg.isMultiArg) {
            if (arg.args.isEmpty()) {
                return LazyFqnClassType.getLazyType("java.lang.Object", LanguageLevel.JDK_1_5, resolveScope, JavaPsiFacade.getInstance((Project)manager.getProject())).createArrayType();
            }
            PsiType leastUpperBound = null;
            PsiElement first = (PsiElement)arg.args.get(0);
            if (first instanceof GrNamedArgument) {
                GrNamedArgument[] args = new GrNamedArgument[arg.args.size()];
                int size = arg.args.size();
                for (int i = 0; i < size; ++i) {
                    args[i] = (GrNamedArgument)arg.args.get(i);
                }
                return GrMapType.createFromNamedArgs(first, args);
            }
            for (PsiElement elem : arg.args) {
                if (!(elem instanceof GrExpression)) continue;
                leastUpperBound = TypesUtil.getLeastUpperBoundNullable(leastUpperBound, ((GrExpression)elem).getType(), manager);
            }
            if (leastUpperBound == null) {
                return null;
            }
            return leastUpperBound.createArrayType();
        }
        if (arg.args.isEmpty()) {
            return null;
        }
        PsiElement elem = (PsiElement)arg.args.get(0);
        if (elem instanceof GrExpression) {
            return ((GrExpression)elem).getType();
        }
        return null;
    }

    @Nullable
    public static PsiType getReturnType(GrSignature signature) {
        if (signature instanceof GrClosureSignature) {
            return ((GrClosureSignature)signature).getReturnType();
        }
        if (signature instanceof GrMultiSignature) {
            GrClosureSignature[] signatures = ((GrMultiSignature)signature).getAllSignatures();
            if (signatures.length == 0) {
                return null;
            }
            PsiType type = signatures[0].getReturnType();
            if (type == null) {
                return null;
            }
            String firstType = type.getCanonicalText();
            for (int i = 1; i < signatures.length; ++i) {
                PsiType _type = signatures[i].getReturnType();
                if (_type == null) {
                    return null;
                }
                if (firstType.equals(_type.getCanonicalText())) continue;
                return null;
            }
            return type;
        }
        return null;
    }

    @Nullable
    public static <Arg> MapResultWithError<Arg> mapSimpleSignatureWithErrors(@NotNull GrClosureSignature signature, @NotNull Arg[] args, @NotNull Function<Arg, PsiType> typeComputer, @NotNull GroovyPsiElement context, int maxErrorCount) {
        GrClosureParameter[] params = signature.getParameters();
        if (args.length < params.length) {
            return null;
        }
        if (args.length > params.length && !signature.isVarargs()) {
            return null;
        }
        int optional = GrClosureSignatureUtil.getOptionalParamCount(params, false);
        assert (optional == 0);
        int errorCount = 0;
        ArgInfo[] map = new ArgInfo[params.length];
        ArrayList<Pair<Integer, PsiType>> errors = new ArrayList<Pair<Integer, PsiType>>(maxErrorCount);
        for (int i = 0; i < params.length; ++i) {
            PsiType type = (PsiType)typeComputer.fun(args[i]);
            if (GrClosureSignatureUtil.isAssignableByConversion(params[i].getType(), type, context)) {
                map[i] = new ArgInfo<Arg>(args[i], type);
                continue;
            }
            if (params[i].getType() instanceof PsiArrayType && i == params.length - 1) {
                if (i + 1 == args.length) {
                    errors.add((Pair<Integer, PsiType>)new Pair((Object)i, (Object)params[i].getType()));
                }
                PsiType ellipsis = ((PsiArrayType)params[i].getType()).getComponentType();
                for (int j = i; j < args.length; ++j) {
                    if (!GrClosureSignatureUtil.isAssignableByConversion(ellipsis, (PsiType)typeComputer.fun(args[j]), context)) {
                        if (++errorCount > maxErrorCount) {
                            return null;
                        }
                        errors.add((Pair<Integer, PsiType>)new Pair((Object)i, (Object)ellipsis));
                    }
                    map[i] = new ArgInfo<Arg>(args[i], type);
                }
                continue;
            }
            if (++errorCount > maxErrorCount) {
                return null;
            }
            errors.add((Pair<Integer, PsiType>)new Pair((Object)i, (Object)params[i].getType()));
        }
        return new MapResultWithError(map, errors);
    }

    public static List<GrClosureSignature> generateSimpleSignatures(@NotNull GrSignature signature) {
        final ArrayList<GrClosureSignature> result = new ArrayList<GrClosureSignature>();
        signature.accept(new GrRecursiveSignatureVisitor(){

            @Override
            public void visitClosureSignature(GrClosureSignature signature) {
                int pcount;
                GrClosureParameter[] original = signature.getParameters();
                ArrayList<1> parameters = new ArrayList<1>(original.length);
                for (GrClosureParameter parameter : original) {
                    parameters.add(new GrDelegatingClosureParameter(parameter){

                        @Override
                        public boolean isOptional() {
                            return false;
                        }

                        @Override
                        @Nullable
                        public GrExpression getDefaultInitializer() {
                            return null;
                        }
                    });
                }
                for (int i = pcount = signature.isVarargs() ? signature.getParameterCount() - 2 : signature.getParameterCount() - 1; i >= 0; --i) {
                    if (!original[i].isOptional()) continue;
                    result.add(new GrImmediateClosureSignatureImpl(parameters.toArray(new GrClosureParameter[parameters.size()]), signature.getReturnType(), signature.isVarargs(), false));
                    parameters.remove(i);
                }
                result.add(new GrImmediateClosureSignatureImpl(parameters.toArray(new GrClosureParameter[parameters.size()]), signature.getReturnType(), signature.isVarargs(), false));
            }
        });
        return result;
    }

    public static class MapResultWithError<Arg> {
        private final ArgInfo<Arg>[] mapping;
        private final List<Pair<Integer, PsiType>> errorsAndExpectedType;

        public MapResultWithError(ArgInfo<Arg>[] mapping, List<Pair<Integer, PsiType>> errorsAndExpectedType) {
            this.mapping = mapping;
            this.errorsAndExpectedType = errorsAndExpectedType;
        }

        public ArgInfo<Arg>[] getMapping() {
            return this.mapping;
        }

        public List<Pair<Integer, PsiType>> getErrors() {
            return this.errorsAndExpectedType;
        }
    }

    private static class InnerArg {
        List<PsiElement> list;
        PsiType type;

        InnerArg(PsiType type, PsiElement ... elements) {
            this.list = new ArrayList<PsiElement>(Arrays.asList(elements));
            this.type = type;
        }
    }

    public static class ArgInfo<ArgType> {
        public static final ArgInfo[] EMPTY_ARRAY = new ArgInfo[0];
        public List<ArgType> args;
        public final boolean isMultiArg;
        public final PsiType type;

        public ArgInfo(List<ArgType> args, boolean multiArg, PsiType type) {
            this.args = args;
            this.isMultiArg = multiArg;
            this.type = type;
        }

        public ArgInfo(ArgType arg, PsiType type) {
            this(Collections.singletonList(arg), false, type);
        }

        public ArgInfo(boolean isMultiArg, PsiType type) {
            this(Collections.emptyList(), isMultiArg, type);
        }

        public static <ArgType> ArgInfo<ArgType>[] empty_array() {
            return EMPTY_ARRAY;
        }
    }

    private static class ParameterMapperForVararg<Arg> {
        private final PsiElement context;
        private final GrClosureParameter[] params;
        private final Arg[] args;
        private final PsiType[] types;
        private final PsiType vararg;
        private final int paramLength;
        private final ArgInfo<Arg>[] map;

        private ParameterMapperForVararg(PsiElement context, GrClosureParameter[] params, Arg[] args, Function<Arg, PsiType> typeComputer) {
            this.context = context;
            this.params = params;
            this.args = args;
            this.types = PsiType.createArray((int)args.length);
            for (int i = 0; i < args.length; ++i) {
                this.types[i] = (PsiType)typeComputer.fun(args[i]);
            }
            this.paramLength = params.length - 1;
            this.vararg = ((PsiArrayType)params[this.paramLength].getType()).getComponentType();
            this.map = new ArgInfo[params.length];
        }

        @Nullable
        private ArgInfo<Arg>[] isApplicable() {
            int i;
            int notOptionals = 0;
            for (i = 0; i < this.paramLength; ++i) {
                if (this.params[i].isOptional()) continue;
                ++notOptionals;
            }
            if (this.isApplicableInternal(0, 0, false, notOptionals)) {
                for (i = 0; i < this.map.length; ++i) {
                    if (this.map[i] != null) continue;
                    this.map[i] = new ArgInfo(false, null);
                }
                return this.map;
            }
            return null;
        }

        private boolean isApplicableInternal(int curParam, int curArg, boolean skipOptionals, int notOptional) {
            int startParam = curParam;
            if (notOptional > this.args.length - curArg) {
                return false;
            }
            if (notOptional == this.args.length - curArg) {
                skipOptionals = true;
            }
            while (curArg < this.args.length) {
                if (skipOptionals) {
                    while (curParam < this.paramLength && this.params[curParam].isOptional()) {
                        ++curParam;
                    }
                }
                if (curParam == this.paramLength) break;
                if (this.params[curParam].isOptional()) {
                    if (GrClosureSignatureUtil.isAssignableByConversion(this.params[curParam].getType(), this.types[curArg], this.context) && this.isApplicableInternal(curParam + 1, curArg + 1, false, notOptional)) {
                        this.map[curParam] = new ArgInfo<Arg>(this.args[curArg], this.types[curArg]);
                        return true;
                    }
                    skipOptionals = true;
                    continue;
                }
                if (!GrClosureSignatureUtil.isAssignableByConversion(this.params[curParam].getType(), this.types[curArg], this.context)) {
                    for (int i = startParam; i < curParam; ++i) {
                        this.map[i] = null;
                    }
                    return false;
                }
                this.map[curParam] = new ArgInfo<Arg>(this.args[curArg], this.types[curArg]);
                --notOptional;
                ++curArg;
                ++curParam;
            }
            ArrayList<Arg> varargs = new ArrayList<Arg>();
            while (curArg < this.args.length) {
                if (!GrClosureSignatureUtil.isAssignableByConversion(this.vararg, this.types[curArg], this.context)) {
                    for (int i = startParam; i < curParam; ++i) {
                        this.map[i] = null;
                    }
                    return false;
                }
                varargs.add(this.args[curArg]);
                ++curArg;
            }
            this.map[this.paramLength] = new ArgInfo(varargs, true, (PsiType)new PsiEllipsisType(this.vararg));
            return true;
        }
    }

    private static class ArgWrapper<Arg> {
        PsiType type;
        @Nullable
        Arg arg;

        private ArgWrapper(PsiType type, @Nullable Arg arg) {
            this.type = type;
            this.arg = arg;
        }
    }

    public static enum ApplicabilityResult {
        applicable,
        inapplicable,
        canBeApplicable,
        ambiguous;


        public static boolean isApplicable(ApplicabilityResult r) {
            return r != inapplicable && r != ambiguous;
        }
    }
}

