/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.annotation;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrAnnotationCollector;

public class GrAnnotationNameValuePairImpl
extends GroovyPsiElementImpl
implements GrAnnotationNameValuePair,
PsiPolyVariantReference {
    public GrAnnotationNameValuePairImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitAnnotationNameValuePair(this);
    }

    public String toString() {
        return "Annotation member value pair";
    }

    @Nullable
    public String getName() {
        PsiElement nameId = this.getNameIdentifierGroovy();
        return nameId != null ? nameId.getText() : null;
    }

    public String getLiteralValue() {
        return null;
    }

    @Override
    @Nullable
    public PsiElement getNameIdentifierGroovy() {
        PsiElement child = this.getFirstChild();
        if (child == null) {
            return null;
        }
        IElementType type = child.getNode().getElementType();
        if (TokenSets.CODE_REFERENCE_ELEMENT_NAME_TOKENS.contains(type)) {
            return child;
        }
        return null;
    }

    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    @Override
    public GrAnnotationMemberValue getValue() {
        return (GrAnnotationMemberValue)this.findChildByClass(GrAnnotationMemberValue.class);
    }

    @NotNull
    public PsiAnnotationMemberValue setValue(@NotNull PsiAnnotationMemberValue newValue) {
        GrAnnotationMemberValue value = this.getValue();
        if (value == null) {
            return (PsiAnnotationMemberValue)this.add((PsiElement)newValue);
        }
        return (PsiAnnotationMemberValue)value.replace((PsiElement)newValue);
    }

    public PsiReference getReference() {
        return this.getNameIdentifierGroovy() == null ? null : this;
    }

    public PsiElement getElement() {
        return this;
    }

    public TextRange getRangeInElement() {
        PsiElement nameId = this.getNameIdentifierGroovy();
        assert (nameId != null);
        return nameId.getTextRange().shiftRight(-this.getTextRange().getStartOffset());
    }

    @Nullable
    public PsiElement resolve() {
        GroovyResolveResult[] results = this.multiResolve(false);
        return results.length == 1 ? results[0].getElement() : null;
    }

    @NotNull
    public String getCanonicalText() {
        return this.getRangeInElement().substring(this.getText());
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        PsiElement nameElement = this.getNameIdentifierGroovy();
        ASTNode newNameNode = GroovyPsiElementFactory.getInstance(this.getProject()).createReferenceNameFromText(newElementName).getNode();
        assert (newNameNode != null);
        if (nameElement != null) {
            ASTNode node = nameElement.getNode();
            assert (node != null);
            this.getNode().replaceChild(node, newNameNode);
        } else {
            PsiElement first = this.getFirstChild();
            ASTNode anchorBefore = first != null ? first.getNode() : null;
            this.getNode().addLeaf(GroovyTokenTypes.mASSIGN, (CharSequence)"=", anchorBefore);
            this.getNode().addChild(newNameNode, anchorBefore);
        }
        return this;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        throw new IncorrectOperationException("NYI");
    }

    public boolean isReferenceTo(PsiElement element) {
        return element instanceof PsiMethod && this.getManager().areElementsEquivalent(element, this.resolve());
    }

    @NotNull
    public Object[] getVariants() {
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }

    @NotNull
    public GroovyResolveResult[] multiResolve(boolean incompleteCode) {
        GrAnnotation annotation = PsiImplUtil.getAnnotation(this);
        if (annotation != null) {
            String name;
            GrCodeReferenceElement ref = annotation.getClassReference();
            PsiElement resolved = ref.resolve();
            String declaredName = this.getName();
            String string = name = declaredName == null ? "value" : declaredName;
            if (resolved instanceof PsiClass) {
                PsiAnnotation collector = GrAnnotationCollector.findAnnotationCollector((PsiClass)resolved);
                if (collector != null) {
                    return GrAnnotationNameValuePairImpl.multiResolveFromAlias(annotation, name, collector);
                }
                if (((PsiClass)resolved).isAnnotationType()) {
                    return GrAnnotationNameValuePairImpl.multiResolveFromAnnotationType((PsiClass)resolved, name);
                }
            }
        }
        return GroovyResolveResult.EMPTY_ARRAY;
    }

    private static GroovyResolveResult[] multiResolveFromAnnotationType(@NotNull PsiClass resolved, @NotNull String name) {
        PsiMethod[] methods = resolved.findMethodsByName(name, false);
        if (methods.length == 0) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        GroovyResolveResult[] results = new GroovyResolveResult[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            PsiMethod method = methods[i];
            results[i] = new GroovyResolveResultImpl((PsiElement)method, true);
        }
        return results;
    }

    private static GroovyResolveResult[] multiResolveFromAlias(@NotNull GrAnnotation alias, @NotNull String name, @NotNull PsiAnnotation annotationCollector) {
        ArrayList result = ContainerUtilRt.newArrayList();
        ArrayList annotations = ContainerUtilRt.newArrayList();
        GrAnnotationCollector.collectAnnotations(annotations, alias, annotationCollector);
        for (GrAnnotation annotation : annotations) {
            PsiElement clazz = annotation.getClassReference().resolve();
            if (!(clazz instanceof PsiClass) || !((PsiClass)clazz).isAnnotationType() || "groovy.transform.AnnotationCollector".equals(((PsiClass)clazz).getQualifiedName())) continue;
            for (PsiMethod method : ((PsiClass)clazz).findMethodsByName(name, false)) {
                result.add(new GroovyResolveResultImpl((PsiElement)method, true));
            }
        }
        return result.toArray(new GroovyResolveResult[result.size()]);
    }
}

