/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.light.LightClassReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrThrowsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.GrReferenceListImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrReferenceListStub;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrThrowsClauseImpl
extends GrReferenceListImpl
implements GrThrowsClause {
    public GrThrowsClauseImpl(GrReferenceListStub stub) {
        super(stub, GroovyElementTypes.THROW_CLAUSE);
    }

    @Override
    protected IElementType getKeywordType() {
        return GroovyTokenTypes.kTHROWS;
    }

    public GrThrowsClauseImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitThrowsClause(this);
    }

    public String toString() {
        return "Throw clause";
    }

    @NotNull
    public PsiJavaCodeReferenceElement[] getReferenceElements() {
        PsiClassType[] types = this.getReferencedTypes();
        if (types.length == 0) {
            return PsiJavaCodeReferenceElement.EMPTY_ARRAY;
        }
        PsiManagerEx manager = this.getManager();
        ArrayList result = ContainerUtil.newArrayList();
        for (PsiClassType type : types) {
            PsiClassType.ClassResolveResult resolveResult = type.resolveGenerics();
            PsiClass resolved = resolveResult.getElement();
            if (resolved == null) continue;
            result.add(new LightClassReference((PsiManager)manager, type.getCanonicalText(), resolved, resolveResult.getSubstitutor()));
        }
        return result.toArray(new PsiJavaCodeReferenceElement[result.size()]);
    }

    public PsiReferenceList.Role getRole() {
        return PsiReferenceList.Role.THROWS_LIST;
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element instanceof GrCodeReferenceElement || element instanceof PsiJavaCodeReferenceElement) {
            if (this.findChildByClass(GrCodeReferenceElement.class) == null) {
                this.getNode().addLeaf(GroovyTokenTypes.kTHROWS, (CharSequence)"throws", null);
            } else {
                PsiElement lastChild = this.getLastChild();
                if (!(lastChild = PsiUtil.skipWhitespacesAndComments(lastChild, false)).getNode().getElementType().equals(GroovyTokenTypes.mCOMMA)) {
                    this.getNode().addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", null);
                }
            }
            if (element instanceof PsiJavaCodeReferenceElement) {
                element = GroovyPsiElementFactory.getInstance(this.getProject()).createCodeReferenceElementFromText(element.getText());
            }
        }
        return super.add(element);
    }
}

