/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrLiteralClassType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapTypeFromNamedArgs;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapTypeImpl;

public abstract class GrMapType
extends GrLiteralClassType {
    private final VolatileNotNullLazyValue<PsiType[]> myParameters = new VolatileNotNullLazyValue<PsiType[]>(){

        @NotNull
        protected PsiType[] compute() {
            PsiType[] keyTypes = GrMapType.this.getAllKeyTypes();
            PsiType[] valueTypes = GrMapType.this.getAllValueTypes();
            if (keyTypes.length == 0 && valueTypes.length == 0) {
                return PsiClassType.EMPTY_ARRAY;
            }
            return new PsiType[]{GrMapType.this.getLeastUpperBound(keyTypes), GrMapType.this.getLeastUpperBound(valueTypes)};
        }
    };

    protected GrMapType(JavaPsiFacade facade, GlobalSearchScope scope) {
        this(facade, scope, LanguageLevel.JDK_1_5);
    }

    protected GrMapType(JavaPsiFacade facade, GlobalSearchScope scope, LanguageLevel languageLevel) {
        super(languageLevel, scope, facade);
    }

    @Override
    @NotNull
    protected String getJavaClassName() {
        return "java.util.LinkedHashMap";
    }

    @Override
    @NotNull
    public String getClassName() {
        return "LinkedHashMap";
    }

    @Nullable
    public abstract PsiType getTypeByStringKey(String var1);

    @NotNull
    public abstract Set<String> getStringKeys();

    public abstract boolean isEmpty();

    @NotNull
    protected abstract PsiType[] getAllKeyTypes();

    @NotNull
    protected abstract PsiType[] getAllValueTypes();

    @NotNull
    protected abstract List<Couple<PsiType>> getOtherEntries();

    @NotNull
    protected abstract LinkedHashMap<String, PsiType> getStringEntries();

    @NotNull
    public PsiType[] getParameters() {
        return (PsiType[])this.myParameters.getValue();
    }

    @NotNull
    public String getInternalCanonicalText() {
        Set<String> stringKeys = this.getStringKeys();
        List<Couple<PsiType>> otherEntries = this.getOtherEntries();
        if (stringKeys.isEmpty()) {
            if (otherEntries.isEmpty()) {
                return "[:]";
            }
            String name = this.getJavaClassName();
            PsiType[] params = this.getParameters();
            return name + "<" + GrMapType.getInternalText(params[0]) + ", " + GrMapType.getInternalText(params[1]) + ">";
        }
        ArrayList<String> components = new ArrayList<String>();
        for (String string : stringKeys) {
            components.add("'" + string + "':" + GrMapType.getInternalCanonicalText(this.getTypeByStringKey(string)));
        }
        for (Couple couple : otherEntries) {
            components.add(GrMapType.getInternalCanonicalText((PsiType)couple.first) + ":" + GrMapType.getInternalCanonicalText((PsiType)couple.second));
        }
        boolean tooMany = components.size() > 2;
        List list = components.subList(0, Math.min(2, components.size()));
        return "[" + StringUtil.join(list, (String)", ") + (tooMany ? ",..." : "") + "]";
    }

    @NotNull
    private static String getInternalText(@Nullable PsiType param) {
        return param == null ? "null" : param.getInternalCanonicalText();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GrMapType) {
            GrMapType other = (GrMapType)((Object)obj);
            return this.getStringEntries().equals(other.getStringEntries()) && this.getOtherEntries().equals(other.getOtherEntries());
        }
        return super.equals(obj);
    }

    public boolean isAssignableFrom(@NotNull PsiType type) {
        return type instanceof GrMapType || super.isAssignableFrom(type);
    }

    public static GrMapType merge(GrMapType l, GrMapType r) {
        GlobalSearchScope scope = l.getScope().intersectWith(r.getResolveScope());
        LinkedHashMap strings = ContainerUtil.newLinkedHashMap();
        strings.putAll(l.getStringEntries());
        strings.putAll(r.getStringEntries());
        ArrayList<Couple<PsiType>> other = new ArrayList<Couple<PsiType>>();
        other.addAll(l.getOtherEntries());
        other.addAll(r.getOtherEntries());
        return GrMapType.create(l.myFacade, scope, strings, other);
    }

    public static GrMapType create(JavaPsiFacade facade, GlobalSearchScope scope, LinkedHashMap<String, PsiType> stringEntries, List<Couple<PsiType>> otherEntries) {
        return new GrMapTypeImpl(facade, scope, stringEntries, otherEntries, LanguageLevel.JDK_1_5);
    }

    public static GrMapType create(GlobalSearchScope scope) {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)scope.getProject());
        List<Couple<PsiType>> otherEntries = Collections.emptyList();
        LinkedHashMap stringEntries = ContainerUtil.newLinkedHashMap();
        return new GrMapTypeImpl(facade, scope, stringEntries, otherEntries, LanguageLevel.JDK_1_5);
    }

    @NotNull
    public PsiClassType setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        return new GrMapTypeImpl(this.myFacade, this.getResolveScope(), this.getStringEntries(), this.getOtherEntries(), languageLevel);
    }

    public static GrMapType createFromNamedArgs(PsiElement context, GrNamedArgument[] args) {
        return new GrMapTypeFromNamedArgs(context, args);
    }

    public String toString() {
        return "map type";
    }
}

