/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClassReferenceType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrLiteralClassType;

public class GrAnonymousClassType
extends GrLiteralClassType {
    private final GrAnonymousClassDefinition myAnonymous;

    public GrAnonymousClassType(@NotNull LanguageLevel languageLevel, @NotNull GlobalSearchScope scope, @NotNull JavaPsiFacade facade, @NotNull GrAnonymousClassDefinition anonymous) {
        super(languageLevel, scope, facade);
        this.myAnonymous = anonymous;
    }

    @Override
    @NotNull
    protected String getJavaClassName() {
        GrCodeReferenceElement ref = this.myAnonymous.getBaseClassReferenceGroovy();
        PsiElement resolved = ref.resolve();
        if (resolved instanceof PsiClass) {
            String qname = ((PsiClass)resolved).getQualifiedName();
            return qname != null ? qname : ((PsiClass)resolved).getName();
        }
        return ref.getClassNameText();
    }

    @Override
    @NotNull
    public String getClassName() {
        return StringUtil.getShortName((String)this.getJavaClassName());
    }

    @Override
    public GrAnonymousClassDefinition resolve() {
        return this.myAnonymous;
    }

    @NotNull
    public PsiType[] getParameters() {
        return this.myAnonymous.getBaseClassReferenceGroovy().getTypeArguments();
    }

    @NotNull
    public PsiClassType setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        return new GrAnonymousClassType(languageLevel, this.myScope, this.myFacade, this.myAnonymous);
    }

    @NotNull
    public String getInternalCanonicalText() {
        return this.getCanonicalText();
    }

    public boolean isValid() {
        return this.myAnonymous.isValid();
    }

    public String toString() {
        return "AnonymousType:" + this.getPresentableText();
    }

    @NotNull
    public PsiClassType getSimpleClassType() {
        return new GrClassReferenceType(this.myAnonymous.getBaseClassReferenceGroovy(), this.myLanguageLevel);
    }
}

