/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.expectedTypes;

import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrParametersOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrTraditionalForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConstructorCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrInstanceOfExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAnnotationMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesContributor;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SubtypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SupertypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GroovyExpectedTypesProvider {
    public static TypeConstraint[] calculateTypeConstraints(final @NotNull GrExpression expression) {
        return TypeInferenceHelper.getCurrentContext().getCachedValue(expression, new Computable<TypeConstraint[]>(){

            public TypeConstraint[] compute() {
                MyCalculator calculator = new MyCalculator(expression);
                PsiElement parent = expression.getParent();
                if (parent instanceof GroovyPsiElement) {
                    ((GroovyPsiElement)parent).accept(calculator);
                } else {
                    parent.accept((PsiElementVisitor)new GroovyPsiElementVisitor(calculator));
                }
                TypeConstraint[] result = calculator.getResult();
                ArrayList custom = ContainerUtil.newArrayList();
                for (GroovyExpectedTypesContributor contributor : (GroovyExpectedTypesContributor[])GroovyExpectedTypesContributor.EP_NAME.getExtensions()) {
                    custom.addAll(contributor.calculateTypeConstraints(expression));
                }
                if (!custom.isEmpty()) {
                    custom.addAll(0, Arrays.asList(result));
                    return custom.toArray(new TypeConstraint[custom.size()]);
                }
                return result;
            }
        });
    }

    public static List<PsiType> getDefaultExpectedTypes(@NotNull GrExpression element) {
        Object[] constraints = GroovyExpectedTypesProvider.calculateTypeConstraints(element);
        return ContainerUtil.map((Object[])constraints, (Function)new Function<TypeConstraint, PsiType>(){

            public PsiType fun(TypeConstraint constraint) {
                return constraint.getDefaultType();
            }
        });
    }

    private static class MyCalculator
    extends GroovyElementVisitor {
        private TypeConstraint[] myResult;
        private final GrExpression myExpression;

        public MyCalculator(GrExpression expression) {
            this.myExpression = (GrExpression)PsiUtil.skipParentheses(expression, true);
            this.myResult = TypeConstraint.EMPTY_ARRAY;
        }

        @Override
        public void visitReturnStatement(GrReturnStatement returnStatement) {
            GrTypeElement typeElement;
            GrParametersOwner parent = (GrParametersOwner)PsiTreeUtil.getParentOfType((PsiElement)returnStatement, (Class[])new Class[]{GrMethod.class, GrClosableBlock.class});
            if (parent instanceof GrMethod && (typeElement = ((GrMethod)parent).getReturnTypeElementGroovy()) != null) {
                PsiType type = typeElement.getType();
                this.myResult = new TypeConstraint[]{SubtypeConstraint.create(type)};
            }
        }

        @Override
        public void visitVariable(GrVariable variable) {
            if (this.myExpression.equals(variable.getInitializerGroovy())) {
                PsiType type = variable.getType();
                this.myResult = MyCalculator.createSimpleSubTypeResult(type);
            }
        }

        @Override
        public void visitNamedArgument(GrNamedArgument argument) {
            PsiElement pparent;
            GrArgumentLabel label = argument.getLabel();
            if (label != null && (pparent = argument.getParent().getParent()) instanceof GrCall && MyCalculator.resolvesToDefaultConstructor((GrCall)pparent)) {
                GroovyResolveResult resolveResult = label.advancedResolve();
                PsiElement resolved = resolveResult.getElement();
                PsiType type = resolved instanceof PsiField ? ((PsiField)resolved).getType() : (resolved instanceof PsiMethod && GroovyPropertyUtils.isSimplePropertySetter((PsiMethod)resolved) ? ((PsiMethod)resolved).getParameterList().getParameters()[0].getType() : null);
                PsiType substituted = resolveResult.getSubstitutor().substitute(type);
                if (substituted != null) {
                    this.myResult = MyCalculator.createSimpleSubTypeResult(substituted);
                }
            }
        }

        private static boolean resolvesToDefaultConstructor(GrCall call) {
            PsiElement resolved;
            PsiMethod method = call.resolveMethod();
            if (method != null && method.isConstructor() && method.getParameterList().getParametersCount() == 0) {
                return true;
            }
            return call instanceof GrConstructorCall && (resolved = PsiImplUtil.extractUniqueResult(((GrConstructorCall)call).multiResolveClass()).getElement()) instanceof PsiClass;
        }

        @Override
        public void visitMethodCallExpression(GrMethodCallExpression methodCall) {
            GrExpression invokedExpression = methodCall.getInvokedExpression();
            if (this.myExpression.equals(invokedExpression)) {
                this.myResult = new TypeConstraint[]{SubtypeConstraint.create("groovy.lang.Closure", methodCall)};
                return;
            }
            GrClosableBlock[] closureArgs = methodCall.getClosureArguments();
            if (ArrayUtil.contains((Object)this.myExpression, (Object[])closureArgs)) {
                GrArgumentList argumentList = methodCall.getArgumentList();
                GrNamedArgument[] namedArgs = argumentList.getNamedArguments();
                GrExpression[] expressionArgs = argumentList.getExpressionArguments();
                GroovyResolveResult[] callVariants = ResolveUtil.getCallVariants(this.myExpression);
                this.processCallVariants(methodCall, callVariants, namedArgs, expressionArgs, closureArgs);
            }
        }

        @Override
        public void visitOpenBlock(GrOpenBlock block) {
            GrStatement[] statements = block.getStatements();
            if (statements.length > 0 && this.myExpression.equals(statements[statements.length - 1])) {
                this.checkExitPoint();
            }
        }

        @Override
        public void visitIfStatement(GrIfStatement ifStatement) {
            if (this.myExpression.equals(ifStatement.getCondition())) {
                this.myResult = new TypeConstraint[]{new SubtypeConstraint((PsiType)TypesUtil.getJavaLangObject(ifStatement), (PsiType)PsiType.BOOLEAN)};
            } else if (this.myExpression.equals(ifStatement.getThenBranch()) || this.myExpression.equals(ifStatement.getElseBranch())) {
                this.checkExitPoint();
            }
        }

        @Override
        public void visitAnnotationMethod(GrAnnotationMethod method) {
            PsiType type = method.getReturnType();
            if (type != null && MyCalculator.isAcceptableAnnotationValueType(type)) {
                this.myResult = MyCalculator.createSimpleSubTypeResult(type);
            }
        }

        @Override
        public void visitAnnotationArrayInitializer(GrAnnotationArrayInitializer arrayInitializer) {
            GrAnnotationNameValuePair nameValuePair = (GrAnnotationNameValuePair)PsiTreeUtil.getParentOfType((PsiElement)arrayInitializer, GrAnnotationNameValuePair.class, (boolean)true, (Class[])new Class[]{GrAnnotationMethod.class});
            if (nameValuePair != null) {
                PsiClass annot = ResolveUtil.resolveAnnotation(arrayInitializer);
                if (annot == null) {
                    return;
                }
                String name = nameValuePair.getName();
                if (name == null) {
                    return;
                }
                this.createResultFromAttrName(annot, name);
            } else {
                GrAnnotationMethod method = (GrAnnotationMethod)PsiTreeUtil.getParentOfType((PsiElement)arrayInitializer, GrAnnotationMethod.class);
                assert (method != null);
                PsiType type = method.getReturnType();
                int count = 1;
                PsiElement parent = arrayInitializer.getParent();
                while (parent instanceof GrAnnotationArrayInitializer) {
                    ++count;
                    parent = parent.getParent();
                }
                while (type instanceof PsiArrayType && count > 0) {
                    type = ((PsiArrayType)type).getComponentType();
                    --count;
                }
                if (type != null && MyCalculator.isAcceptableAnnotationValueType(type)) {
                    this.myResult = MyCalculator.createSimpleSubTypeResult(type);
                }
            }
        }

        @Override
        public void visitAnnotationNameValuePair(GrAnnotationNameValuePair nameValuePair) {
            PsiClass annot;
            if (this.myExpression.equals(nameValuePair.getValue()) && (annot = ResolveUtil.resolveAnnotation(nameValuePair.getParent())) != null) {
                String name = nameValuePair.getName();
                if (name != null) {
                    this.createResultFromAttrName(annot, name);
                } else {
                    PsiMethod[] valueAttr = annot.findMethodsByName("value", false);
                    if (valueAttr.length > 0) {
                        boolean canHaveSimpleExpr;
                        boolean bl = canHaveSimpleExpr = ContainerUtil.find((Object[])annot.getMethods(), (Condition)new Condition<PsiMethod>(){

                            public boolean value(PsiMethod method) {
                                return !"value".equals(method.getName()) && (!(method instanceof PsiAnnotationMethod) || ((PsiAnnotationMethod)method).getDefaultValue() == null);
                            }
                        }) == null;
                        if (canHaveSimpleExpr) {
                            this.createResultFromAnnotationAttribute(valueAttr[0]);
                        }
                    }
                }
            }
        }

        private void createResultFromAttrName(PsiClass annotation, String attrName) {
            PsiMethod[] attrs = annotation.findMethodsByName(attrName, false);
            if (attrs.length > 0) {
                this.createResultFromAnnotationAttribute(attrs[0]);
            }
        }

        private void createResultFromAnnotationAttribute(PsiMethod attr) {
            PsiType type = attr.getReturnType();
            while (type instanceof PsiArrayType) {
                type = ((PsiArrayType)type).getComponentType();
            }
            if (type != null && MyCalculator.isAcceptableAnnotationValueType(type)) {
                this.myResult = MyCalculator.createSimpleSubTypeResult(type);
            }
        }

        private static boolean isAcceptableAnnotationValueType(PsiType type) {
            return type instanceof PsiPrimitiveType || type.equalsToText("java.lang.String") || type.equalsToText("java.lang.Class") || type instanceof PsiClassType && ((PsiClassType)type).resolve() != null && ((PsiClassType)type).resolve().isEnum();
        }

        @NotNull
        private static TypeConstraint[] createSimpleSubTypeResult(@NotNull PsiType type) {
            return new TypeConstraint[]{new SubtypeConstraint(type, type)};
        }

        private void checkExitPoint() {
            PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)this.myExpression, (Class[])new Class[]{PsiMethod.class, GrClosableBlock.class});
            if (element instanceof GrMethod) {
                final GrMethod method = (GrMethod)element;
                ControlFlowUtils.visitAllExitPoints(method.getBlock(), new ControlFlowUtils.ExitPointVisitor(){

                    @Override
                    public boolean visitExitPoint(Instruction instruction, @Nullable GrExpression returnValue) {
                        if (returnValue == myExpression) {
                            PsiType returnType = method.getReturnType();
                            if (returnType != null) {
                                MyCalculator.access$102(this, MyCalculator.createSimpleSubTypeResult(returnType));
                            }
                            return false;
                        }
                        return true;
                    }
                });
            }
        }

        @Override
        public void visitWhileStatement(GrWhileStatement whileStatement) {
            if (this.myExpression.equals(whileStatement.getCondition())) {
                this.myResult = new TypeConstraint[]{new SubtypeConstraint((PsiType)TypesUtil.getJavaLangObject(whileStatement), (PsiType)PsiType.BOOLEAN)};
            }
        }

        @Override
        public void visitTraditionalForClause(GrTraditionalForClause forClause) {
            if (this.myExpression.equals(forClause.getCondition())) {
                this.myResult = new TypeConstraint[]{new SubtypeConstraint((PsiType)TypesUtil.getJavaLangObject(forClause), (PsiType)PsiType.BOOLEAN)};
            }
        }

        @Override
        public void visitArgumentList(GrArgumentList list) {
            this.processCallVariants(list, ResolveUtil.getCallVariants(list), list.getNamedArguments(), list.getExpressionArguments(), GrClosableBlock.EMPTY_ARRAY);
        }

        private void processCallVariants(@NotNull PsiElement place, @NotNull GroovyResolveResult[] variants, @NotNull GrNamedArgument[] namedArguments, @NotNull GrExpression[] expressionArguments, @NotNull GrClosableBlock[] closureArguments) {
            List<Pair<PsiParameter, PsiType>> expectedParams = ResolveUtil.collectExpectedParamsByArg(place, variants, namedArguments, expressionArguments, closureArguments, this.myExpression);
            this.collectExpectedTypeFromPossibleParams(expectedParams);
        }

        private void collectExpectedTypeFromPossibleParams(List<Pair<PsiParameter, PsiType>> expectedParams) {
            ArrayList constraints = ContainerUtil.newArrayList();
            for (Pair<PsiParameter, PsiType> pair : expectedParams) {
                PsiType type = (PsiType)pair.second;
                if (type == null) continue;
                constraints.add(SubtypeConstraint.create(type));
                if (!(type instanceof PsiArrayType) || !((PsiParameter)pair.first).isVarArgs()) continue;
                constraints.add(SubtypeConstraint.create(((PsiArrayType)type).getComponentType()));
            }
            if (!constraints.isEmpty()) {
                this.myResult = constraints.toArray(new TypeConstraint[constraints.size()]);
            }
        }

        @Override
        public void visitBinaryExpression(GrBinaryExpression expression) {
            PsiType otherType;
            IElementType type = expression.getOperationTokenType();
            GrExpression left = expression.getLeftOperand();
            GrExpression right = expression.getRightOperand();
            GrExpression other = this.myExpression == left ? right : left;
            PsiType psiType = otherType = other != null ? other.getType() : null;
            if (otherType == null) {
                return;
            }
            GroovyResolveResult[] callVariants = expression.multiResolve(true);
            if (this.myExpression == left || callVariants.length == 0) {
                if (type == GroovyTokenTypes.mPLUS && otherType.equalsToText("java.lang.String")) {
                    PsiClassType obj = TypesUtil.getJavaLangObject(expression);
                    this.myResult = MyCalculator.createSimpleSubTypeResult((PsiType)obj);
                } else if (type == GroovyTokenTypes.mREGEX_FIND || type == GroovyTokenTypes.mREGEX_MATCH) {
                    PsiClassType string = TypesUtil.createType("java.lang.String", expression);
                    this.myResult = MyCalculator.createSimpleSubTypeResult((PsiType)string);
                } else {
                    this.myResult = MyCalculator.createSimpleSubTypeResult(otherType);
                }
            } else {
                this.processCallVariants(expression, callVariants, GrNamedArgument.EMPTY_ARRAY, new GrExpression[]{this.myExpression}, GrClosableBlock.EMPTY_ARRAY);
            }
        }

        @Override
        public void visitInstanceofExpression(GrInstanceOfExpression expression) {
            GrExpression operand = expression.getOperand();
            GrTypeElement typeElement = expression.getTypeElement();
            if (typeElement == null) {
                return;
            }
            if (this.myExpression == operand) {
                PsiType type = typeElement.getType();
                this.myResult = new TypeConstraint[]{new SupertypeConstraint(type, type)};
            }
        }

        @Override
        public void visitAssignmentExpression(GrAssignmentExpression expression) {
            PsiType rType;
            GrExpression rValue = expression.getRValue();
            GrExpression lValue = expression.getLValue();
            if (this.myExpression.equals(rValue)) {
                PsiType type;
                GroovyResolveResult result;
                PsiElement resolved;
                PsiType lType = lValue.getNominalType();
                if (lType != null) {
                    this.myResult = new TypeConstraint[]{SubtypeConstraint.create(lType)};
                } else if (lValue instanceof GrReferenceExpression && (resolved = (result = ((GrReferenceExpression)lValue).advancedResolve()).getElement()) instanceof GrVariable && (type = ((GrVariable)resolved).getTypeGroovy()) != null) {
                    this.myResult = new TypeConstraint[]{SubtypeConstraint.create(result.getSubstitutor().substitute(type))};
                }
            } else if (this.myExpression.equals(lValue) && rValue != null && (rType = rValue.getType()) != null) {
                this.myResult = new TypeConstraint[]{SupertypeConstraint.create(rType)};
            }
        }

        @Override
        public void visitThrowStatement(GrThrowStatement throwStatement) {
            PsiClassType throwable = PsiType.getJavaLangThrowable((PsiManager)this.myExpression.getManager(), (GlobalSearchScope)throwStatement.getResolveScope());
            this.myResult = new TypeConstraint[]{SubtypeConstraint.create((PsiType)throwable)};
        }

        @Override
        public void visitUnaryExpression(final GrUnaryExpression expression) {
            TypeConstraint constraint = new TypeConstraint((PsiType)PsiType.INT){

                @Override
                public boolean satisfied(PsiType type, @NotNull PsiElement context) {
                    PsiType boxed = TypesUtil.boxPrimitiveType(type, context.getManager(), context.getResolveScope());
                    IElementType opToken = expression.getOperationTokenType();
                    GrExpression operand = expression.getOperand();
                    GroovyResolveResult[] candidates = TypesUtil.getOverloadedUnaryOperatorCandidates(boxed, opToken, operand != null ? operand : expression, PsiType.EMPTY_ARRAY);
                    return candidates.length > 0;
                }

                @Override
                @NotNull
                public PsiType getDefaultType() {
                    return PsiType.INT;
                }
            };
            this.myResult = new TypeConstraint[]{constraint};
        }

        @Override
        public void visitParenthesizedExpression(GrParenthesizedExpression expression) {
            PsiElement parent = expression.getParent();
            if (parent instanceof GroovyPsiElement) {
                ((GroovyPsiElement)parent).accept(this);
            } else {
                parent.accept((PsiElementVisitor)new GroovyPsiElementVisitor(this));
            }
        }

        @Override
        public void visitListOrMap(GrListOrMap listOrMap) {
            if (listOrMap.isMap()) {
                return;
            }
            TypeConstraint[] constraints = GroovyExpectedTypesProvider.calculateTypeConstraints(listOrMap);
            ArrayList<PsiType> result = new ArrayList<PsiType>(constraints.length);
            for (TypeConstraint constraint : constraints) {
                PsiType type;
                PsiType iterable;
                if (!(constraint instanceof SubtypeConstraint) || (iterable = com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)(type = constraint.getType()), (boolean)true)) == null) continue;
                result.add(iterable);
            }
            if (result.isEmpty()) {
                this.myResult = TypeConstraint.EMPTY_ARRAY;
            } else {
                this.myResult = new TypeConstraint[result.size()];
                for (int i = 0; i < result.size(); ++i) {
                    PsiType type = (PsiType)result.get(i);
                    if (type == null) continue;
                    this.myResult[i] = SubtypeConstraint.create(type);
                }
            }
        }

        @Override
        public void visitCaseLabel(GrCaseLabel caseLabel) {
            PsiElement parent = caseLabel.getParent().getParent();
            if (!(parent instanceof GrSwitchStatement)) {
                return;
            }
            GrExpression condition = ((GrSwitchStatement)parent).getCondition();
            if (condition == null) {
                return;
            }
            PsiType type = condition.getType();
            if (type == null) {
                return;
            }
            this.myResult = new TypeConstraint[]{SubtypeConstraint.create(type)};
        }

        @Override
        public void visitSwitchStatement(GrSwitchStatement switchStatement) {
            GrCaseSection[] sections = switchStatement.getCaseSections();
            ArrayList<PsiType> types = new ArrayList<PsiType>(sections.length);
            for (GrCaseSection section : sections) {
                for (GrCaseLabel label : section.getCaseLabels()) {
                    PsiType type;
                    GrExpression value = label.getValue();
                    if (value == null || (type = value.getType()) == null) continue;
                    types.add(type);
                }
            }
            PsiType upperBoundNullable = TypesUtil.getLeastUpperBoundNullable(types, switchStatement.getManager());
            if (upperBoundNullable == null) {
                return;
            }
            this.myResult = new TypeConstraint[]{SubtypeConstraint.create(upperBoundNullable)};
        }

        public TypeConstraint[] getResult() {
            return this.myResult;
        }

        static /* synthetic */ TypeConstraint[] access$102(MyCalculator x0, TypeConstraint[] x1) {
            x0.myResult = x1;
            return x1;
        }
    }
}

