/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs;

import gnu.trove.TObjectIntHashMap;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs.DefinitionMap;

public class ReachingDefinitionsDfaInstance
implements DfaInstance<DefinitionMap> {
    private final TObjectIntHashMap<String> myVarToIndexMap = new TObjectIntHashMap();
    private final Instruction[] myFlow;

    public int getVarIndex(String varName) {
        return this.myVarToIndexMap.get((Object)varName);
    }

    public ReachingDefinitionsDfaInstance(Instruction[] flow) {
        this.myFlow = flow;
        int num = 0;
        for (Instruction instruction : flow) {
            String name;
            if (!(instruction instanceof ReadWriteVariableInstruction) || this.myVarToIndexMap.containsKey((Object)(name = ((ReadWriteVariableInstruction)instruction).getVariableName()))) continue;
            this.myVarToIndexMap.put((Object)name, num++);
        }
    }

    @Override
    public void fun(DefinitionMap m, Instruction instruction) {
        if (instruction instanceof ReadWriteVariableInstruction) {
            ReadWriteVariableInstruction varInsn = (ReadWriteVariableInstruction)instruction;
            String name = varInsn.getVariableName();
            assert (this.myVarToIndexMap.containsKey((Object)name)) : name + "; " + Arrays.asList(this.myFlow).contains(instruction);
            int num = this.myVarToIndexMap.get((Object)name);
            if (varInsn.isWrite()) {
                m.registerDef(varInsn, num);
            }
        }
    }

    @Override
    @NotNull
    public DefinitionMap initial() {
        return new DefinitionMap();
    }

    @Override
    public boolean isForward() {
        return true;
    }
}

