/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.declaration;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.ThrowClause;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.annotations.AnnotationArguments;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.parameters.ParameterList;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.TupleParse;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.blocks.OpenOrClosableBlock;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.constructor.ConstructorBody;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.AssignmentExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class VariableDefinitions {
    public static IElementType parseDefinitions(@NotNull PsiBuilder builder, boolean isInClass, boolean isInAnnotation, @Nullable String typeDefinitionName, boolean hasModifiers, boolean canBeTuple, @NotNull GroovyParser parser) {
        boolean isStringName;
        boolean isLParenth = builder.getTokenType() == GroovyTokenTypes.mLPAREN;
        boolean bl = isStringName = builder.getTokenType() == GroovyTokenTypes.mSTRING_LITERAL || builder.getTokenType() == GroovyTokenTypes.mGSTRING_LITERAL;
        if (builder.getTokenType() != GroovyTokenTypes.mIDENT && !isStringName && !isLParenth) {
            builder.error(GroovyBundle.message("indentifier.or.string.or.left.parenth.literal.expected", new Object[0]));
            return GroovyElementTypes.WRONGWAY;
        }
        if (isLParenth && !canBeTuple) {
            builder.error(GroovyBundle.message("indentifier.or.string.or.left.parenth.literal.expected", new Object[0]));
            return GroovyElementTypes.WRONGWAY;
        }
        if (isInAnnotation && isStringName) {
            builder.error(GroovyBundle.message("string.name.unexpected", new Object[0]));
        }
        if (!isLParenth) {
            PsiBuilder.Marker varMarker = builder.mark();
            boolean isConstructor = isInClass && !isInAnnotation && typeDefinitionName != null && builder.getTokenType() == GroovyTokenTypes.mIDENT && typeDefinitionName.equals(builder.getTokenText());
            builder.advanceLexer();
            if (GroovyTokenTypes.mLPAREN != builder.getTokenType()) {
                varMarker.rollbackTo();
            } else {
                varMarker.drop();
                return VariableDefinitions.parseMethod(builder, isInAnnotation, hasModifiers, parser, isConstructor);
            }
        }
        return VariableDefinitions.parseVar(builder, isInClass, hasModifiers, parser, isLParenth);
    }

    private static IElementType parseVar(PsiBuilder builder, boolean isInClass, boolean hasModifiers, GroovyParser parser, boolean LParenth) {
        PsiBuilder.Marker varAssMarker = builder.mark();
        IElementType declarator = VariableDefinitions.parseDeclarator(builder, LParenth);
        if (declarator != GroovyElementTypes.WRONGWAY) {
            boolean wasAssignment = VariableDefinitions.parseAssignment(builder, parser);
            if (declarator == GroovyElementTypes.TUPLE_DECLARATION) {
                varAssMarker.drop();
                if (!wasAssignment && !hasModifiers) {
                    builder.error(GroovyBundle.message("assignment.expected", new Object[0]));
                    return GroovyElementTypes.WRONGWAY;
                }
            } else if (isInClass) {
                varAssMarker.done(GroovyElementTypes.FIELD);
            } else {
                varAssMarker.done((IElementType)GroovyElementTypes.VARIABLE);
            }
            while (ParserUtils.getToken(builder, GroovyTokenTypes.mCOMMA)) {
                ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
                if (!((Object)((Object)GroovyElementTypes.WRONGWAY)).equals(VariableDefinitions.parseVariableOrField(builder, isInClass, parser)) || declarator != GroovyTokenTypes.mIDENT) continue;
                return GroovyElementTypes.VARIABLE_DEFINITION_ERROR;
            }
            if (isInClass && declarator == GroovyElementTypes.TUPLE_DECLARATION) {
                builder.error(GroovyBundle.message("tuple.cant.be.placed.in.class", new Object[0]));
            }
            return GroovyElementTypes.VARIABLE_DEFINITION;
        }
        varAssMarker.drop();
        builder.error(GroovyBundle.message("identifier.expected", new Object[0]));
        return GroovyElementTypes.WRONGWAY;
    }

    private static IElementType parseMethod(PsiBuilder builder, boolean isAnnotationMember, boolean hasModifiers, GroovyParser parser, boolean constructor) {
        if (!hasModifiers && !constructor) {
            builder.error(GroovyBundle.message("method.definition.without.modifier", new Object[0]));
            return GroovyElementTypes.WRONGWAY;
        }
        builder.advanceLexer();
        ParameterList.parse(builder, GroovyTokenTypes.mRPAREN, parser);
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        if (!ParserUtils.getToken(builder, GroovyTokenTypes.mRPAREN)) {
            builder.error(GroovyBundle.message("rparen.expected", new Object[0]));
            ThrowClause.parse(builder);
            return VariableDefinitions.methodType(isAnnotationMember, constructor);
        }
        if (isAnnotationMember && builder.getTokenType() == GroovyTokenTypes.kDEFAULT) {
            ParserUtils.getToken(builder, GroovyTokenTypes.kDEFAULT);
            ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
            if (!AnnotationArguments.parseAnnotationMemberValueInitializer(builder, parser)) {
                builder.error(GroovyBundle.message("annotation.initializer.expected", new Object[0]));
            }
        }
        if (ParserUtils.lookAhead(builder, GroovyTokenTypes.mNLS, GroovyTokenTypes.kTHROWS) || ParserUtils.lookAhead(builder, GroovyTokenTypes.mNLS, GroovyTokenTypes.mLCURLY)) {
            ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        }
        if (isAnnotationMember && builder.getTokenType() == GroovyTokenTypes.kTHROWS) {
            builder.error(GroovyBundle.message("throws.clause.is.not.allowed.in.at.interface", new Object[0]));
        }
        ThrowClause.parse(builder);
        if (builder.getTokenType() == GroovyTokenTypes.mLCURLY || ParserUtils.lookAhead(builder, GroovyTokenTypes.mNLS, GroovyTokenTypes.mLCURLY)) {
            ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
            if (isAnnotationMember) {
                builder.error(GroovyBundle.message("separator.or.rcurly.expected", new Object[0]));
            }
            if (constructor) {
                ConstructorBody.parseConstructorBody(builder, parser);
            } else {
                OpenOrClosableBlock.parseOpenBlock(builder, parser);
            }
        }
        return VariableDefinitions.methodType(isAnnotationMember, constructor);
    }

    private static IElementType methodType(boolean isAnnotationMember, boolean isConstructor) {
        return isAnnotationMember ? GroovyElementTypes.ANNOTATION_METHOD : (isConstructor ? GroovyElementTypes.CONSTRUCTOR_DEFINITION : GroovyElementTypes.METHOD_DEFINITION);
    }

    private static IElementType parseVariableOrField(PsiBuilder builder, boolean isInClass, GroovyParser parser) {
        PsiBuilder.Marker varAssMarker = builder.mark();
        if (ParserUtils.getToken(builder, GroovyTokenTypes.mIDENT)) {
            VariableDefinitions.parseAssignment(builder, parser);
            if (isInClass) {
                varAssMarker.done(GroovyElementTypes.FIELD);
                return GroovyElementTypes.FIELD;
            }
            varAssMarker.done((IElementType)GroovyElementTypes.VARIABLE);
            return GroovyElementTypes.VARIABLE;
        }
        varAssMarker.drop();
        builder.error("Identifier expected");
        return GroovyElementTypes.WRONGWAY;
    }

    private static IElementType parseDeclarator(PsiBuilder builder, boolean isTuple) {
        if (isTuple && builder.getTokenType() == GroovyTokenTypes.mLPAREN && TupleParse.parseTupleForVariableDeclaration(builder)) {
            return GroovyElementTypes.TUPLE_DECLARATION;
        }
        if (!isTuple && ParserUtils.getToken(builder, GroovyTokenTypes.mIDENT)) {
            return GroovyTokenTypes.mIDENT;
        }
        return GroovyElementTypes.WRONGWAY;
    }

    private static boolean parseAssignment(PsiBuilder builder, GroovyParser parser) {
        if (ParserUtils.getToken(builder, GroovyTokenTypes.mASSIGN)) {
            PsiBuilder.Marker marker = builder.mark();
            ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
            if (!AssignmentExpression.parse(builder, parser, true)) {
                marker.rollbackTo();
                builder.error(GroovyBundle.message("expression.expected", new Object[0]));
                return false;
            }
            marker.drop();
            return true;
        }
        return false;
    }
}

