/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.modifiers;

import com.intellij.lang.PsiBuilder;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.annotations.Annotation;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class Modifiers {
    public static boolean parse(PsiBuilder builder, GroovyParser parser) {
        boolean endsWithNewLine;
        PsiBuilder.Marker modifiersMarker = builder.mark();
        if (!Annotation.parse(builder, parser) && !Modifiers.parseModifier(builder)) {
            modifiersMarker.done(GroovyElementTypes.MODIFIERS);
            return false;
        }
        PsiBuilder.Marker newLineMarker = builder.mark();
        do {
            newLineMarker.drop();
            newLineMarker = builder.mark();
            endsWithNewLine = ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        } while (Annotation.parse(builder, parser) || Modifiers.parseModifier(builder));
        if (endsWithNewLine) {
            newLineMarker.rollbackTo();
        } else {
            newLineMarker.drop();
        }
        modifiersMarker.done(GroovyElementTypes.MODIFIERS);
        ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        return true;
    }

    public static boolean parseModifier(PsiBuilder builder) {
        if (TokenSets.MODIFIERS.contains(builder.getTokenType())) {
            builder.advanceLexer();
            return true;
        }
        return false;
    }
}

