/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionConfidence;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.shell.GroovyShellRunnerImpl;

public class GroovyCompletionConfidence
extends CompletionConfidence {
    @NotNull
    public ThreeState shouldSkipAutopopup(@NotNull PsiElement contextElement, @NotNull PsiFile psiFile, int offset) {
        if (CodeInsightSettings.getInstance().SELECT_AUTOPOPUP_SUGGESTIONS_BY_CHARS && psiFile.getUserData(GroovyShellRunnerImpl.GROOVY_SHELL_FILE) == Boolean.TRUE) {
            return ThreeState.YES;
        }
        if (PsiImplUtil.isLeafElementOfType((PsiElement)contextElement, (TokenSet)TokenSets.STRING_LITERALS)) {
            PsiElement parent = contextElement.getParent();
            if (parent != null) {
                for (PsiReference reference : parent.getReferences()) {
                    if (reference.isSoft() || !reference.getRangeInElement().shiftRight(parent.getTextOffset()).containsOffset(offset)) continue;
                    return ThreeState.NO;
                }
            }
            return ThreeState.YES;
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"def"})).accepts((Object)contextElement)) {
            return ThreeState.YES;
        }
        if (contextElement.textMatches((CharSequence)"..") || contextElement.textMatches((CharSequence)"...")) {
            return ThreeState.YES;
        }
        return ThreeState.UNSURE;
    }
}

