/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

class GrThisSuperCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static final ElementPattern<PsiElement> AFTER_DOT = ((PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf(new String[]{"."})).withParent(GrReferenceExpression.class);
    private static final String[] THIS_SUPER = new String[]{"this", "super"};

    GrThisSuperCompletionProvider() {
    }

    public static void register(CompletionContributor contributor) {
        contributor.extend(CompletionType.BASIC, AFTER_DOT, (CompletionProvider)new GrThisSuperCompletionProvider());
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        String shortcut;
        PsiElement position = parameters.getPosition();
        assert (position.getParent() instanceof GrReferenceExpression);
        GrReferenceExpression refExpr = (GrReferenceExpression)position.getParent();
        GrExpression qualifier = refExpr.getQualifierExpression();
        if (!(qualifier instanceof GrReferenceExpression)) {
            return;
        }
        GrReferenceExpression referenceExpression = (GrReferenceExpression)qualifier;
        PsiElement resolved = referenceExpression.resolve();
        if (!(resolved instanceof PsiClass)) {
            return;
        }
        if (parameters.getInvocationCount() > 0 && CompletionUtil.shouldShowFeature((CompletionParameters)parameters, (String)"editing.completion.global.member.name") && StringUtil.isNotEmpty((String)(shortcut = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("CodeCompletion"))))) {
            result.addLookupAdvertisement("Pressing " + shortcut + " twice without a class qualifier would show all accessible static methods");
        }
        if (!PsiUtil.hasEnclosingInstanceInScope((PsiClass)resolved, position, false)) {
            return;
        }
        for (String keyword : THIS_SUPER) {
            result.addElement((LookupElement)LookupElementBuilder.create((String)keyword));
        }
    }
}

