/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightFieldBuilder;
import com.intellij.util.ArrayUtil;
import icons.JetgroovyIcons;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class GrPropertyForCompletion
extends LightFieldBuilder {
    @NotNull
    private final PsiMethod myOriginalAccessor;

    public GrPropertyForCompletion(@NotNull PsiMethod method, @NotNull String name, @NotNull PsiType type) {
        super(method.getManager(), name, type);
        this.myOriginalAccessor = method;
        ArrayList<String> modifiers = new ArrayList<String>();
        if (method.hasModifierProperty("public")) {
            modifiers.add("public");
        }
        if (method.hasModifierProperty("protected")) {
            modifiers.add("protected");
        }
        if (method.hasModifierProperty("private")) {
            modifiers.add("private");
        }
        if (method.hasModifierProperty("static")) {
            modifiers.add("static");
        }
        this.setContainingClass(method.getContainingClass());
        this.setModifiers(ArrayUtil.toStringArray(modifiers));
        this.setBaseIcon(JetgroovyIcons.Groovy.Property);
    }

    @NotNull
    public PsiMethod getOriginalAccessor() {
        return this.myOriginalAccessor;
    }

    public int hashCode() {
        int isStatic = this.hasModifierProperty("static") ? 1 : 0;
        int visibilityModifier = this.getVisibilityCode();
        return this.getName().hashCode() << 3 + isStatic << 2 + visibilityModifier;
    }

    private int getVisibilityCode() {
        int visibilityModifier = this.hasModifierProperty("public") ? 3 : (this.hasModifierProperty("protected") ? 2 : (this.hasModifierProperty("private") ? 1 : 0));
        return visibilityModifier;
    }

    @NotNull
    public String getName() {
        return super.getName();
    }

    public String toString() {
        return this.getName();
    }

    public boolean isEquivalentTo(PsiElement another) {
        if (!(another instanceof GrPropertyForCompletion)) {
            return false;
        }
        if (!((GrPropertyForCompletion)another).getName().equals(this.getName())) {
            return false;
        }
        if (this.hasModifierProperty("static") != ((GrPropertyForCompletion)another).hasModifierProperty("static")) {
            return false;
        }
        return this.getVisibilityCode() == ((GrPropertyForCompletion)another).getVisibilityCode();
    }
}

