/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.actions.GroovyTemplatesFactory;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.conversions.ClassNameDiffersFromFileNamePredicate;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public class MoveClassToNewFileIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element, Project project, Editor editor) throws IncorrectOperationException {
        GrTypeDefinition psiClass = (GrTypeDefinition)element.getParent();
        String name = psiClass.getName();
        PsiFile file = psiClass.getContainingFile();
        String fileExtension = FileUtilRt.getExtension((String)file.getName());
        String newFileName = name + "." + fileExtension;
        PsiDirectory dir = file.getParent();
        if (dir != null && dir.findFile(newFileName) != null) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                String message = GroovyIntentionsBundle.message("file.exists", newFileName, dir.getName());
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)this.getFamilyName(), null);
            }
            return;
        }
        GroovyFile newFile = (GroovyFile)GroovyTemplatesFactory.createFromTemplate(dir, name, newFileName, "GroovyClass.groovy", true, new String[0]);
        GrTypeDefinition template = newFile.getTypeDefinitions()[0];
        PsiElement newClass = template.replace(psiClass);
        GrDocComment docComment = psiClass.getDocComment();
        if (newClass instanceof GrTypeDefinition && docComment != null) {
            GrDocComment newDoc = ((GrTypeDefinition)newClass).getDocComment();
            if (newDoc != null) {
                newDoc.replace(docComment);
            } else {
                PsiElement parent = newClass.getParent();
                parent.addBefore((PsiElement)docComment, (PsiElement)psiClass);
                parent.getNode().addLeaf(GroovyTokenTypes.mNLS, (CharSequence)"\n", psiClass.getNode());
            }
            docComment.delete();
        }
        psiClass.delete();
        IntentionUtils.positionCursor(project, newClass.getContainingFile(), newClass.getNavigationElement());
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new ClassNameDiffersFromFileNamePredicate(null, true);
    }
}

