/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.utils.EquivalenceChecker;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class ReplaceIfWithTernaryIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element, Project project, Editor editor) throws IncorrectOperationException {
        GrConditionalExpression conditional;
        GrIfStatement ifStatement = (GrIfStatement)element.getParent();
        PsiElement thenBranch = ReplaceIfWithTernaryIntention.skipBlock(ifStatement.getThenBranch());
        PsiElement elseBranch = ReplaceIfWithTernaryIntention.skipBlock(ifStatement.getElseBranch());
        if (thenBranch instanceof GrAssignmentExpression && elseBranch instanceof GrAssignmentExpression) {
            GrAssignmentExpression assignment = (GrAssignmentExpression)GroovyPsiElementFactory.getInstance(project).createStatementFromText("a = b ? c : d");
            assignment.getLValue().replaceWithExpression(((GrAssignmentExpression)thenBranch).getLValue(), true);
            conditional = (GrConditionalExpression)assignment.getRValue();
            ReplaceIfWithTernaryIntention.replaceConditional(conditional, ifStatement.getCondition(), ((GrAssignmentExpression)thenBranch).getRValue(), ((GrAssignmentExpression)elseBranch).getRValue());
            ifStatement.replaceWithStatement(assignment);
        }
        if (thenBranch instanceof GrReturnStatement && elseBranch instanceof GrReturnStatement) {
            GrReturnStatement returnSt = (GrReturnStatement)GroovyPsiElementFactory.getInstance(project).createStatementFromText("return a ? b : c");
            conditional = (GrConditionalExpression)returnSt.getReturnValue();
            ReplaceIfWithTernaryIntention.replaceConditional(conditional, ifStatement.getCondition(), ((GrReturnStatement)thenBranch).getReturnValue(), ((GrReturnStatement)elseBranch).getReturnValue());
            ifStatement.replaceWithStatement(returnSt);
        }
    }

    private static void replaceConditional(GrConditionalExpression conditional, GrExpression condition, GrExpression then, GrExpression elze) {
        conditional.getCondition().replaceWithExpression(condition, true);
        conditional.getThenBranch().replaceWithExpression(then, true);
        conditional.getElseBranch().replaceWithExpression(elze, true);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement e) {
                if (!e.getNode().getElementType().equals(GroovyTokenTypes.kIF)) {
                    return false;
                }
                if (!(e.getParent() instanceof GrIfStatement)) {
                    return false;
                }
                GrIfStatement ifStatement = (GrIfStatement)e.getParent();
                PsiElement thenBranch = ReplaceIfWithTernaryIntention.skipBlock(ifStatement.getThenBranch());
                PsiElement elseBranch = ReplaceIfWithTernaryIntention.skipBlock(ifStatement.getElseBranch());
                if (thenBranch instanceof GrAssignmentExpression && elseBranch instanceof GrAssignmentExpression && ((GrAssignmentExpression)thenBranch).getRValue() != null && ((GrAssignmentExpression)elseBranch).getRValue() != null) {
                    GrExpression lvalue1 = ((GrAssignmentExpression)thenBranch).getLValue();
                    GrExpression lvalue2 = ((GrAssignmentExpression)elseBranch).getLValue();
                    return EquivalenceChecker.expressionsAreEquivalent(lvalue1, lvalue2);
                }
                return thenBranch instanceof GrReturnStatement && elseBranch instanceof GrReturnStatement && ((GrReturnStatement)thenBranch).getReturnValue() != null && ((GrReturnStatement)elseBranch).getReturnValue() != null;
            }
        };
    }

    private static PsiElement skipBlock(PsiElement e) {
        if (e instanceof GrBlockStatement && ((GrBlockStatement)e).getBlock().getStatements().length == 1) {
            return ((GrBlockStatement)e).getBlock().getStatements()[0];
        }
        return e;
    }
}

