/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.intentions.base.MutablyNamedIntention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.control.ConjunctionPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public class FlipConjunctionIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        GrBinaryExpression binaryExpression = (GrBinaryExpression)element;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        String conjunction = FlipConjunctionIntention.getConjunction(tokenType);
        return GroovyIntentionsBundle.message("flip.smth.intention.name", conjunction);
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new ConjunctionPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element, Project project, Editor editor) throws IncorrectOperationException {
        GrBinaryExpression exp = (GrBinaryExpression)element;
        IElementType tokenType = exp.getOperationTokenType();
        GrExpression lhs = exp.getLeftOperand();
        String lhsText = lhs.getText();
        GrExpression rhs = exp.getRightOperand();
        String rhsText = rhs.getText();
        String conjunction = FlipConjunctionIntention.getConjunction(tokenType);
        String newExpression = rhsText + conjunction + lhsText;
        PsiImplUtil.replaceExpression(newExpression, exp);
    }

    private static String getConjunction(IElementType tokenType) {
        return tokenType.equals(GroovyTokenTypes.mLAND) ? "&&" : "||";
    }
}

