/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gant;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.sun.jdi.ReferenceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.extensions.debugger.ScriptPositionManagerHelper;
import org.jetbrains.plugins.groovy.gant.GantScriptType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.runner.GroovyScriptUtil;

public class GantPositionManagerHelper
extends ScriptPositionManagerHelper {
    @Override
    public boolean isAppropriateRuntimeName(@NotNull String runtimeName) {
        return true;
    }

    @Override
    public boolean isAppropriateScriptFile(@NotNull PsiFile scriptFile) {
        return GroovyScriptUtil.isSpecificScriptFile(scriptFile, GantScriptType.INSTANCE);
    }

    @Override
    @NotNull
    public String getRuntimeScriptName(@NotNull String originalName, GroovyFile groovyFile) {
        return originalName;
    }

    @Override
    public PsiFile getExtraScriptIfNotFound(ReferenceType refType, @NotNull String runtimeName, Project project, GlobalSearchScope scope) {
        try {
            String fileName = StringUtil.getShortName((String)runtimeName);
            PsiFile[] files = FilenameIndex.getFilesByName((Project)project, (String)(fileName + "." + "gant"), (GlobalSearchScope)scope);
            if (files.length == 0) {
                files = FilenameIndex.getFilesByName((Project)project, (String)(fileName + "." + "gant"), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
            }
            if (files.length == 1) {
                return files[0];
            }
            if (files.length == 0) {
                files = FilenameIndex.getFilesByName((Project)project, (String)(fileName + ".groovy"), (GlobalSearchScope)scope);
                if (files.length == 0) {
                    files = FilenameIndex.getFilesByName((Project)project, (String)(fileName + "." + "gant"), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
                }
                PsiFile candidate = null;
                for (PsiFile file : files) {
                    if (!GroovyScriptUtil.isSpecificScriptFile(file, GantScriptType.INSTANCE)) continue;
                    if (candidate != null) {
                        return null;
                    }
                    candidate = file;
                }
                return candidate;
            }
        }
        catch (ProcessCanceledException processCanceledException) {
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        return null;
    }
}

