/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;

public class HandlerUtils {
    private HandlerUtils() {
    }

    public static boolean isEnabled(@NotNull Editor editor, @NotNull DataContext dataContext, @Nullable EditorActionHandler originalHandler) {
        Language language;
        Project project = HandlerUtils.getProject(dataContext);
        if (project != null && (language = PsiUtilBase.getLanguageInEditor((Editor)editor, (Project)project)) == GroovyLanguage.INSTANCE) {
            return true;
        }
        return originalHandler == null || originalHandler.isEnabled(editor, dataContext);
    }

    public static boolean isReadOnly(@NotNull Editor editor) {
        if (editor.isViewer()) {
            return true;
        }
        Document document = editor.getDocument();
        return !document.isWritable();
    }

    public static boolean canBeInvoked(Editor editor, Project project) {
        if (HandlerUtils.isReadOnly(editor)) {
            return false;
        }
        return HandlerUtils.getPsiFile(editor, project) != null;
    }

    public static PsiFile getPsiFile(@NotNull Editor editor, @NotNull DataContext dataContext) {
        return HandlerUtils.getPsiFile(editor, HandlerUtils.getProject(dataContext));
    }

    public static PsiFile getPsiFile(@NotNull Editor editor, Project project) {
        return PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
    }

    @Nullable
    public static Language getLanguage(@NotNull DataContext dataContext) {
        return (Language)DataKeys.LANGUAGE.getData(dataContext);
    }

    @Nullable
    public static Project getProject(@NotNull DataContext dataContext) {
        return (Project)DataKeys.PROJECT.getData(dataContext);
    }
}

