/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionContext;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.ConverterProvider;
import com.intellij.conversion.ProjectConverter;
import com.intellij.conversion.RunManagerSettings;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class GroovyRunConfigurationConverterProvider
extends ConverterProvider {
    public GroovyRunConfigurationConverterProvider() {
        super("groovy-script-run-configurations");
    }

    @NotNull
    public String getConversionDescription() {
        return "Groovy Script run configurations will be converted into a new format";
    }

    @NotNull
    public ProjectConverter createConverter(@NotNull ConversionContext context) {
        return new ProjectConverter(){

            public ConversionProcessor<RunManagerSettings> createRunConfigurationsConverter() {
                return new ConversionProcessor<RunManagerSettings>(){

                    public boolean isConversionNeeded(RunManagerSettings settings) {
                        for (Element element : settings.getRunConfigurations()) {
                            if (!"Groovy Script".equals(element.getAttributeValue("factoryName")) || "true".equals(element.getAttributeValue("default"))) continue;
                            return true;
                        }
                        return false;
                    }

                    public void process(RunManagerSettings settings) throws CannotConvertException {
                        for (Element element : settings.getRunConfigurations()) {
                            if (!"Groovy Script".equals(element.getAttributeValue("factoryName"))) continue;
                            element.setAttribute("factoryName", "Groovy");
                        }
                    }
                };
            }
        };
    }
}

