/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import icons.JetgroovyIcons;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.config.GroovyLibraryPresentationProviderBase;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public class GroovyLibraryPresentationProvider
extends GroovyLibraryPresentationProviderBase {
    public static final LibraryKind GROOVY_KIND = LibraryKind.create((String)"groovy");

    public GroovyLibraryPresentationProvider() {
        super(GROOVY_KIND);
    }

    @Override
    public boolean managesLibrary(VirtualFile[] libraryFiles) {
        return LibrariesUtil.getGroovyLibraryHome(libraryFiles) != null;
    }

    @Override
    @Nls
    public String getLibraryVersion(VirtualFile[] libraryFiles) {
        String home = LibrariesUtil.getGroovyLibraryHome(libraryFiles);
        if (home == null) {
            return "undefined";
        }
        return GroovyConfigUtils.getInstance().getSDKVersion(home);
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return JetgroovyIcons.Groovy.Groovy_16x16;
    }

    @Override
    public boolean isSDKHome(@NotNull VirtualFile file) {
        return GroovyConfigUtils.getInstance().isSDKHome(file);
    }

    @Override
    protected void fillLibrary(String path, LibraryEditor libraryEditor) {
        File libDir;
        File[] jars;
        File srcRoot = new File(path + "/src/main");
        if (srcRoot.exists()) {
            libraryEditor.addRoot(VfsUtil.getUrlForLibraryRoot((File)srcRoot), OrderRootType.SOURCES);
        }
        if ((jars = (libDir = new File(path + "/lib")).exists() ? libDir.listFiles() : new File(path + "/embeddable").listFiles()) != null) {
            for (File file : jars) {
                if (!file.getName().endsWith(".jar")) continue;
                libraryEditor.addRoot(VfsUtil.getUrlForLibraryRoot((File)file), OrderRootType.CLASSES);
            }
        }
    }

    @Override
    @NotNull
    public String getSDKVersion(String path) {
        return GroovyConfigUtils.getInstance().getSDKVersion(path);
    }

    @Override
    @Nls
    @NotNull
    public String getLibraryCategoryName() {
        return "Groovy";
    }
}

