/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.threading;

import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyUnsynchronizedMethodOverridesSynchronizedMethodInspection
extends BaseInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return "Threading issues";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return "Unsynchronized method overrides synchronized method";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Unsynchronized method '#ref' overrides a synchronized method #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitMethod(GrMethod method) {
            PsiMethod[] superMethods;
            super.visitMethod(method);
            if (method.isConstructor()) {
                return;
            }
            if (method.hasModifierProperty("synchronized")) {
                return;
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
                if (!superMethod.hasModifierProperty("synchronized")) continue;
                this.registerMethodError(method, new Object[0]);
                return;
            }
        }
    }
}

