/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.secondUnsafeCall;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.annotator.inspections.SecondUnsafeCallQuickFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovySuppressableInspectionTool;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class SecondUnsafeCallInspection
extends GroovySuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new GroovyPsiElementVisitor(new GroovyElementVisitor(){

            @Override
            public void visitReferenceExpression(GrReferenceExpression refExpression) {
                SecondUnsafeCallInspection.checkForSecondUnsafeCall(refExpression, holder);
            }
        });
    }

    private static void checkForSecondUnsafeCall(GrExpression expression, ProblemsHolder holder) {
        SecondUnsafeCallInspection.checkForSecondUnsafeCall(expression, holder, null);
    }

    private static void checkForSecondUnsafeCall(GrExpression expression, ProblemsHolder holder, @Nullable PsiElement highlightElement) {
        GrReferenceExpression referenceExpression;
        if (highlightElement == null) {
            highlightElement = expression;
        }
        if (GroovyTokenTypes.mDOT.equals((referenceExpression = (GrReferenceExpression)expression).getDotTokenType())) {
            GrExpression qualifier = referenceExpression.getQualifierExpression();
            if (qualifier instanceof GrMethodCallExpression) {
                GrExpression expression1 = ((GrMethodCallExpression)qualifier).getInvokedExpression();
                if (!(expression1 instanceof GrReferenceExpression)) {
                    return;
                }
                if (GroovyTokenTypes.mOPTIONAL_DOT.equals(((GrReferenceExpression)expression1).getDotTokenType())) {
                    holder.registerProblem(highlightElement, GroovyInspectionBundle.message("call.can.throw.npe", new Object[0]), new LocalQuickFix[]{new SecondUnsafeCallQuickFix()});
                }
            } else if (qualifier instanceof GrReferenceExpression && GroovyTokenTypes.mOPTIONAL_DOT.equals(((GrReferenceExpression)qualifier).getDotTokenType())) {
                holder.registerProblem(highlightElement, GroovyInspectionBundle.message("call.can.throw.npe", new Object[0]), new LocalQuickFix[]{new SecondUnsafeCallQuickFix()});
            }
        }
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return "Probable bugs";
    }

    @NotNull
    public String[] getGroupPath() {
        return new String[]{"Groovy", this.getGroupDisplayName()};
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return GroovyInspectionBundle.message("second.unsafe.call", new Object[0]);
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return "SecondUnsafeCall";
    }

    public boolean isEnabledByDefault() {
        return true;
    }
}

