/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.naming;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import com.intellij.refactoring.RefactoringFactory;
import com.intellij.refactoring.RenameRefactoring;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;

public class RenameFix
extends GroovyFix {
    private final String targetName;

    public RenameFix() {
        this.targetName = null;
    }

    public RenameFix(@NonNls String targetName) {
        this.targetName = targetName;
    }

    @NotNull
    public String getName() {
        if (this.targetName == null) {
            return "Rename";
        }
        return "Rename to " + this.targetName;
    }

    @Override
    public void doFix(final Project project, ProblemDescriptor descriptor) {
        PsiElement nameIdentifier = descriptor.getPsiElement();
        final PsiElement elementToRename = nameIdentifier.getParent();
        if (this.targetName == null) {
            RefactoringActionHandlerFactory factory = RefactoringActionHandlerFactory.getInstance();
            final RefactoringActionHandler renameHandler = factory.createRenameHandler();
            DataManager dataManager = DataManager.getInstance();
            final DataContext dataContext = dataManager.getDataContext();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    renameHandler.invoke(project, new PsiElement[]{elementToRename}, dataContext);
                }
            };
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                runnable.run();
            } else {
                ApplicationManager.getApplication().invokeLater(runnable, project.getDisposed());
            }
        } else {
            RefactoringFactory factory = RefactoringFactory.getInstance((Project)project);
            RenameRefactoring renameRefactoring = factory.createRename(elementToRename, this.targetName);
            renameRefactoring.run();
        }
    }
}

