/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.metrics;

import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

class NegationCountVisitor
extends GroovyRecursiveElementVisitor {
    private int negationCount = 0;

    NegationCountVisitor() {
    }

    @Override
    public void visitElement(GroovyPsiElement element) {
        int oldCount = 0;
        if (element instanceof GrMethod) {
            oldCount = this.negationCount;
        }
        super.visitElement(element);
        if (element instanceof GrMethod) {
            this.negationCount = oldCount;
        }
    }

    @Override
    public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
        super.visitBinaryExpression(expression);
        IElementType tokenType = expression.getOperationTokenType();
        GrExpression rhs = expression.getRightOperand();
        if (rhs == null) {
            return;
        }
        if (GroovyTokenTypes.mNOT_EQUAL.equals(tokenType)) {
            ++this.negationCount;
        }
    }

    @Override
    public void visitUnaryExpression(GrUnaryExpression grUnaryExpression) {
        super.visitUnaryExpression(grUnaryExpression);
        IElementType sign = grUnaryExpression.getOperationTokenType();
        if (GroovyTokenTypes.mLNOT.equals(sign)) {
            ++this.negationCount;
        }
    }

    public int getNegationCount() {
        return this.negationCount;
    }
}

