/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLoopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrContinueStatement;

public class GroovyUnnecessaryContinueInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return "Control Flow";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return "Unnecessary 'continue' statement";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "#ref is unnecessary as the last statement in a loop #loc";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    @Override
    @Nullable
    protected GroovyFix buildFix(@NotNull PsiElement location) {
        return new UnnecessaryContinueFix();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitContinueStatement(GrContinueStatement continueStatement) {
            super.visitContinueStatement(continueStatement);
            if (continueStatement.getContainingFile().getViewProvider() instanceof TemplateLanguageFileViewProvider) {
                return;
            }
            GrStatement continuedStatement = continueStatement.findTargetStatement();
            if (continuedStatement == null) {
                return;
            }
            if (!(continuedStatement instanceof GrLoopStatement)) {
                return;
            }
            GrStatement body = ((GrLoopStatement)continuedStatement).getBody();
            if (body == null) {
                return;
            }
            if (body instanceof GrBlockStatement && ControlFlowUtils.blockCompletesWithStatement((GrBlockStatement)body, continueStatement) || !(body instanceof GrBlockStatement) && ControlFlowUtils.statementCompletesWithStatement(body, continueStatement)) {
                this.registerStatementError(continueStatement, new Object[0]);
            }
        }
    }

    private static class UnnecessaryContinueFix
    extends GroovyFix {
        private UnnecessaryContinueFix() {
        }

        @NotNull
        public String getName() {
            return "Remove unnecessary continue";
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement continueKeywordElement = descriptor.getPsiElement();
            GrContinueStatement continueStatement = (GrContinueStatement)continueKeywordElement.getParent();
            assert (continueStatement != null);
            continueStatement.removeStatement();
        }
    }
}

