/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.dsl.psi.PsiClassCategory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class NewInstanceOfSingletonInspection
extends BaseInspection {
    private static final Logger LOG = Logger.getInstance(NewInstanceOfSingletonInspection.class);

    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            @Override
            public void visitNewExpression(GrNewExpression newExpression) {
                super.visitNewExpression(newExpression);
                GrCodeReferenceElement refElement = newExpression.getReferenceElement();
                if (refElement == null) {
                    return;
                }
                if (newExpression.getArrayDeclaration() != null) {
                    return;
                }
                PsiElement resolved = refElement.resolve();
                if (resolved instanceof GrTypeDefinition && PsiClassCategory.hasAnnotation((GrTypeDefinition)resolved, "groovy.lang.Singleton")) {
                    this.registerError((PsiElement)newExpression, GroovyInspectionBundle.message("new.instance.of.singleton", new Object[0]));
                }
            }
        };
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected GroovyFix buildFix(final @NotNull PsiElement location) {
        GrCodeReferenceElement refElement = ((GrNewExpression)location).getReferenceElement();
        LOG.assertTrue(refElement != null);
        final GrTypeDefinition singleton = (GrTypeDefinition)refElement.resolve();
        LOG.assertTrue(singleton != null);
        return new GroovyFix(){

            @Override
            protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
                GrExpression instanceRef = GroovyPsiElementFactory.getInstance(project).createExpressionFromText(singleton.getQualifiedName() + ".instance");
                GrExpression replaced = ((GrNewExpression)location).replaceWithExpression(instanceRef, true);
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)replaced);
            }

            @NotNull
            public String getName() {
                return GroovyInspectionBundle.message("replace.new.expression.with.0.instance", singleton.getName());
            }
        };
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return "Potentially confusing code constructs";
    }

    @Override
    protected String buildErrorString(Object ... args) {
        return (String)args[0];
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return "New instance of class annotated with @groovy.lang.Singleton";
    }
}

