/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.actions.AbstractBatchSuppressByNoInspectionCommentFix;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocCommentOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameter;

public class SuppressForMemberFix
extends AbstractBatchSuppressByNoInspectionCommentFix {
    private String myKey;
    private final boolean myForClass;

    public SuppressForMemberFix(@NotNull HighlightDisplayKey key, boolean forClass) {
        super(key.getID(), false);
        this.myForClass = forClass;
    }

    @Nullable
    public GrDocCommentOwner getContainer(PsiElement context) {
        if (context == null || context instanceof PsiFile) {
            return null;
        }
        GrDocCommentOwner container = null;
        GrDocComment docComment = (GrDocComment)PsiTreeUtil.getParentOfType((PsiElement)context, GrDocComment.class);
        if (docComment != null) {
            container = docComment.getOwner();
        }
        if (container == null) {
            container = (GrDocCommentOwner)PsiTreeUtil.getParentOfType((PsiElement)context, GrDocCommentOwner.class);
        }
        while (container instanceof GrAnonymousClassDefinition || container instanceof GrTypeParameter) {
            if ((container = (GrDocCommentOwner)PsiTreeUtil.getParentOfType((PsiElement)container, GrDocCommentOwner.class)) != null) continue;
            return null;
        }
        if (this.myForClass) {
            while (container != null) {
                GrTypeDefinition parentClass = (GrTypeDefinition)PsiTreeUtil.getParentOfType((PsiElement)container, GrTypeDefinition.class);
                if (parentClass == null && container instanceof GrTypeDefinition) {
                    return container;
                }
                container = parentClass;
            }
        }
        return container;
    }

    @NotNull
    public String getText() {
        return this.myKey != null ? InspectionsBundle.message((String)this.myKey, (Object[])new Object[0]) : "Suppress for member";
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiElement context) {
        GrDocCommentOwner container = this.getContainer(context);
        this.myKey = container instanceof PsiClass ? "suppress.inspection.class" : (container instanceof PsiMethod ? "suppress.inspection.method" : "suppress.inspection.field");
        return container != null && context.getManager().isInProject(context);
    }

    protected boolean replaceSuppressionComments(PsiElement container) {
        return false;
    }

    protected void createSuppression(@NotNull Project project, @NotNull PsiElement element, @NotNull PsiElement container) throws IncorrectOperationException {
        GrModifierList modifierList = (GrModifierList)((PsiModifierListOwner)container).getModifierList();
        if (modifierList != null) {
            SuppressForMemberFix.addSuppressAnnotation(project, modifierList, this.myID);
        }
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
    }

    private static void addSuppressAnnotation(Project project, GrModifierList modifierList, String id) throws IncorrectOperationException {
        PsiAnnotation annotation = modifierList.findAnnotation("java.lang.SuppressWarnings");
        GrExpression toAdd = GroovyPsiElementFactory.getInstance(project).createExpressionFromText("\"" + id + "\"");
        if (annotation != null) {
            PsiAnnotationMemberValue value = annotation.findDeclaredAttributeValue(null);
            if (value instanceof GrAnnotationArrayInitializer) {
                value.add((PsiElement)toAdd);
            } else if (value != null) {
                GrAnnotation anno = GroovyPsiElementFactory.getInstance(project).createAnnotationFromText("@A([])");
                GrAnnotationArrayInitializer list = (GrAnnotationArrayInitializer)anno.findDeclaredAttributeValue(null);
                list.add((PsiElement)value);
                list.add(toAdd);
                annotation.setDeclaredAttributeValue(null, (PsiAnnotationMemberValue)list);
            }
        } else {
            modifierList.addAnnotation("java.lang.SuppressWarnings").setDeclaredAttributeValue(null, (PsiAnnotationMemberValue)toAdd);
        }
    }
}

