/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.PsiFile;
import org.jetbrains.plugins.groovy.editor.HandlerUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GroovyToJavaGenerator;

public class DumpGroovyStubsAction
extends AnAction
implements DumbAware {
    public void update(AnActionEvent e) {
        PsiFile psiFile;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        if (editor != null && (psiFile = HandlerUtils.getPsiFile(editor, e.getDataContext())) instanceof GroovyFile) {
            e.getPresentation().setEnabled(true);
            return;
        }
        e.getPresentation().setEnabled(false);
    }

    public void actionPerformed(AnActionEvent e) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        if (editor == null) {
            return;
        }
        PsiFile psiFile = HandlerUtils.getPsiFile(editor, e.getDataContext());
        if (!(psiFile instanceof GroovyFile)) {
            return;
        }
        StringBuilder builder = GroovyToJavaGenerator.generateStubs(psiFile);
        System.out.println(builder.toString());
    }
}

