/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NdkTask;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.builder.core.AndroidBuilder;
import com.android.ide.common.internal.LoggedErrorException;
import com.android.ide.common.process.LoggedProcessOutputHandler;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.gradle.api.Task;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;

@ParallelizableTask
public class RenderscriptCompile
extends NdkTask {
    private File sourceOutputDir;
    private File resOutputDir;
    private File objOutputDir;
    private File libOutputDir;
    private List<File> sourceDirs;
    private List<File> importDirs;
    private Integer targetApi;
    private boolean supportMode;
    private int optimLevel;
    private boolean debugBuild;
    private boolean ndkMode;

    @Input
    public String getBuildToolsVersion() {
        return this.getBuildTools().getRevision().toString();
    }

    @OutputDirectory
    public File getSourceOutputDir() {
        return this.sourceOutputDir;
    }

    public void setSourceOutputDir(File sourceOutputDir) {
        this.sourceOutputDir = sourceOutputDir;
    }

    @OutputDirectory
    public File getResOutputDir() {
        return this.resOutputDir;
    }

    public void setResOutputDir(File resOutputDir) {
        this.resOutputDir = resOutputDir;
    }

    @OutputDirectory
    public File getObjOutputDir() {
        return this.objOutputDir;
    }

    public void setObjOutputDir(File objOutputDir) {
        this.objOutputDir = objOutputDir;
    }

    @OutputDirectory
    public File getLibOutputDir() {
        return this.libOutputDir;
    }

    public void setLibOutputDir(File libOutputDir) {
        this.libOutputDir = libOutputDir;
    }

    @InputFiles
    public List<File> getSourceDirs() {
        return this.sourceDirs;
    }

    public void setSourceDirs(List<File> sourceDirs) {
        this.sourceDirs = sourceDirs;
    }

    @InputFiles
    public List<File> getImportDirs() {
        return this.importDirs;
    }

    public void setImportDirs(List<File> importDirs) {
        this.importDirs = importDirs;
    }

    @Input
    public Integer getTargetApi() {
        return this.targetApi;
    }

    public void setTargetApi(Integer targetApi) {
        this.targetApi = targetApi;
    }

    @Input
    public boolean isSupportMode() {
        return this.supportMode;
    }

    public void setSupportMode(boolean supportMode) {
        this.supportMode = supportMode;
    }

    @Input
    public int getOptimLevel() {
        return this.optimLevel;
    }

    public void setOptimLevel(int optimLevel) {
        this.optimLevel = optimLevel;
    }

    @Input
    public boolean isDebugBuild() {
        return this.debugBuild;
    }

    public void setDebugBuild(boolean debugBuild) {
        this.debugBuild = debugBuild;
    }

    @Input
    public boolean isNdkMode() {
        return this.ndkMode;
    }

    public void setNdkMode(boolean ndkMode) {
        this.ndkMode = ndkMode;
    }

    @TaskAction
    void taskAction() throws IOException, InterruptedException, ProcessException, LoggedErrorException {
        File sourceDestDir = this.getSourceOutputDir();
        FileUtils.cleanOutputDir((File)sourceDestDir);
        File resDestDir = this.getResOutputDir();
        FileUtils.cleanOutputDir((File)resDestDir);
        File objDestDir = this.getObjOutputDir();
        FileUtils.cleanOutputDir((File)objDestDir);
        File libDestDir = this.getLibOutputDir();
        FileUtils.cleanOutputDir((File)libDestDir);
        List importFolders = AndroidBuilder.getLeafFolders((String)"rsh", (List[])new List[]{this.getImportDirs(), this.getSourceDirs()});
        this.getBuilder().compileAllRenderscriptFiles(this.getSourceDirs(), importFolders, sourceDestDir, resDestDir, objDestDir, libDestDir, this.getTargetApi().intValue(), this.isDebugBuild(), this.getOptimLevel(), this.isNdkMode(), this.isSupportMode(), this.getNdkConfig() == null ? null : this.getNdkConfig().getAbiFilters(), (ProcessOutputHandler)new LoggedProcessOutputHandler(this.getILogger()));
    }

    public static class ConfigAction
    implements TaskConfigAction<RenderscriptCompile> {
        private final VariantScope scope;

        public ConfigAction(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("compile", "Renderscript");
        }

        @Override
        public Class<RenderscriptCompile> getType() {
            return RenderscriptCompile.class;
        }

        @Override
        public void execute(RenderscriptCompile renderscriptTask) {
            BaseVariantData<? extends BaseVariantOutputData> variantData = this.scope.getVariantData();
            GradleVariantConfiguration config = variantData.getVariantConfiguration();
            variantData.renderscriptCompileTask = renderscriptTask;
            boolean ndkMode = config.getRenderscriptNdkModeEnabled();
            renderscriptTask.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            renderscriptTask.setVariantName(config.getFullName());
            ConventionMappingHelper.map((Task)renderscriptTask, "targetApi", () -> ((GradleVariantConfiguration)config).getRenderscriptTarget());
            renderscriptTask.supportMode = config.getRenderscriptSupportModeEnabled();
            renderscriptTask.ndkMode = ndkMode;
            renderscriptTask.debugBuild = ((CoreBuildType)config.getBuildType()).isRenderscriptDebuggable();
            renderscriptTask.optimLevel = ((CoreBuildType)config.getBuildType()).getRenderscriptOptimLevel();
            ConventionMappingHelper.map((Task)renderscriptTask, "sourceDirs", () -> ((GradleVariantConfiguration)config).getRenderscriptSourceList());
            ConventionMappingHelper.map((Task)renderscriptTask, "importDirs", () -> ((GradleVariantConfiguration)config).getRenderscriptImports());
            renderscriptTask.setSourceOutputDir(this.scope.getRenderscriptSourceOutputDir());
            renderscriptTask.setResOutputDir(this.scope.getRenderscriptResOutputDir());
            renderscriptTask.setObjOutputDir(this.scope.getRenderscriptObjOutputDir());
            renderscriptTask.setLibOutputDir(this.scope.getRenderscriptLibOutputDir());
            ConventionMappingHelper.map((Task)renderscriptTask, "ndkConfig", config::getNdkConfig);
        }
    }
}

