/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.AndroidGradleOptions;
import com.android.build.gradle.internal.incremental.DexPackagingPolicy;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.incremental.InstantRunPatchingPolicy;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.PackagingScope;
import com.android.build.gradle.tasks.PackageAndroidArtifact;
import com.android.builder.model.SigningConfig;
import com.android.builder.packaging.DuplicateFileException;
import com.android.builder.profile.ProcessRecorder;
import com.android.ide.common.res2.FileStatus;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.wireless.android.sdk.stats.AndroidStudioStats;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.tooling.BuildException;

@ParallelizableTask
public class PackageApplication
extends PackageAndroidArtifact {
    private boolean inOldMode;

    @Override
    protected boolean isIncremental() {
        return !this.inOldMode;
    }

    @Override
    protected void doFullTaskAction() throws IOException {
        if (this.inOldMode) {
            this.doOldTask();
            this.recordMetrics();
            return;
        }
        super.doFullTaskAction();
        this.recordMetrics();
    }

    @Override
    protected void doIncrementalTaskAction(Map<File, FileStatus> changedInputs) throws IOException {
        if (this.inOldMode) {
            this.doFullTaskAction();
            this.recordMetrics();
            return;
        }
        super.doIncrementalTaskAction(changedInputs);
        this.recordMetrics();
    }

    private void doOldTask() {
        try {
            ImmutableSet.Builder dexFoldersForApk = ImmutableSet.builder();
            ImmutableList.Builder javaResourcesForApk = ImmutableList.builder();
            Collection<File> javaResourceFiles = this.getJavaResourceFiles();
            if (javaResourceFiles != null) {
                javaResourcesForApk.addAll(javaResourceFiles);
            }
            switch (this.dexPackagingPolicy) {
                case INSTANT_RUN_SHARDS_IN_SINGLE_APK: {
                    File zippedDexes = this.zipDexesForInstantRun(this.getDexFolders(), (ImmutableSet.Builder<File>)dexFoldersForApk);
                    javaResourcesForApk.add((Object)zippedDexes);
                    break;
                }
                case INSTANT_RUN_MULTI_APK: {
                    for (File dexFolder : this.getDexFolders()) {
                        if (!dexFolder.getName().contains("main_slice")) continue;
                        dexFoldersForApk.add((Object)dexFolder);
                    }
                    break;
                }
                case STANDARD: {
                    dexFoldersForApk.addAll(this.getDexFolders());
                    break;
                }
                default: {
                    throw new RuntimeException("Unhandled DexPackagingPolicy : " + this.getDexPackagingPolicy());
                }
            }
            this.getBuilder().oldPackageApk(this.getResourceFile().getAbsolutePath(), (Set)dexFoldersForApk.build(), (Collection)javaResourcesForApk.build(), this.getJniFolders(), this.getAssets(), this.getAbiFilters(), this.getJniDebugBuild(), (SigningConfig)this.getSigningConfig(), this.getOutputFile(), this.getMinSdkVersion(), this.getNoCompressPredicate());
        }
        catch (DuplicateFileException e) {
            Logger logger = this.getLogger();
            logger.error("Error: duplicate files during packaging of APK " + this.getOutputFile().getAbsolutePath());
            logger.error("\tPath in archive: " + e.getArchivePath());
            int index = 1;
            for (File file : e.getSourceFiles()) {
                logger.error("\tOrigin " + index++ + ": " + file);
            }
            logger.error("You can ignore those files in your build.gradle:");
            logger.error("\tandroid {");
            logger.error("\t  packagingOptions {");
            logger.error("\t    exclude '" + e.getArchivePath() + "'");
            logger.error("\t  }");
            logger.error("\t}");
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            if (rootCause instanceof NoSuchAlgorithmException) {
                throw new BuildException(rootCause.getMessage() + ": try using a newer JVM to build your application.", rootCause);
            }
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
        try {
            this.instantRunContext.addChangedFile(this.instantRunFileType, this.getOutputFile());
        }
        catch (IOException e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File zipDexesForInstantRun(Iterable<File> dexFolders, ImmutableSet.Builder<File> dexFoldersForApk) throws IOException {
        File tmpZipFile = new File(this.instantRunSupportDir, "classes.zip");
        com.google.common.io.Files.createParentDirs((File)tmpZipFile);
        zipFile.setLevel(0);
        try (ZipOutputStream zipFile = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(tmpZipFile)));){
            for (File dexFolder : dexFolders) {
                if (dexFolder.getName().contains("instant-run")) {
                    dexFoldersForApk.add((Object)dexFolder);
                    continue;
                }
                for (File file : com.google.common.io.Files.fileTreeTraverser().breadthFirstTraversal((Object)dexFolder)) {
                    if (!file.isFile() || !file.getName().endsWith(".dex")) continue;
                    String entryName = file.getParentFile().getName() + "-" + file.getName();
                    zipFile.putNextEntry(new ZipEntry(entryName));
                    try {
                        com.google.common.io.Files.copy((File)file, (OutputStream)zipFile);
                    }
                    finally {
                        zipFile.closeEntry();
                    }
                }
            }
        }
        File finalResourceFile = new File(this.instantRunSupportDir, "resources.zip");
        zipFile = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(finalResourceFile)));
        try {
            zipFile.putNextEntry(new ZipEntry("instant-run.zip"));
            try {
                com.google.common.io.Files.copy((File)tmpZipFile, (OutputStream)zipFile);
            }
            finally {
                zipFile.closeEntry();
            }
        }
        finally {
            zipFile.close();
        }
        return finalResourceFile;
    }

    private void recordMetrics() {
        Long resourcesApSize;
        long metricsStartTime = System.nanoTime();
        AndroidStudioStats.GradleBuildProjectMetrics.Builder metrics = AndroidStudioStats.GradleBuildProjectMetrics.newBuilder();
        Long apkSize = PackageApplication.getSize(this.getOutputFile());
        if (apkSize != null) {
            metrics.setApkSize(apkSize.longValue());
        }
        if ((resourcesApSize = PackageApplication.getSize(this.getResourceFile())) != null) {
            metrics.setResourcesApSize(resourcesApSize.longValue());
        }
        metrics.setMetricsTimeNs(System.nanoTime() - metricsStartTime);
        ProcessRecorder.getProject((String)this.getProject().getPath()).setMetrics(metrics);
    }

    private static Long getSize(File file) {
        if (file == null) {
            return null;
        }
        try {
            return Files.size(file.toPath());
        }
        catch (IOException e) {
            return null;
        }
    }

    public static class InstantRunResourcesConfigAction
    extends PackageAndroidArtifact.ConfigAction<PackageApplication> {
        private final File mOutputFile;

        public InstantRunResourcesConfigAction(File outputFile, PackagingScope scope, InstantRunPatchingPolicy patchingPolicy) {
            super(scope, patchingPolicy);
            this.mOutputFile = outputFile;
        }

        @Override
        public String getName() {
            return this.packagingScope.getTaskName("packageInstantRunResources");
        }

        @Override
        public Class<PackageApplication> getType() {
            return PackageApplication.class;
        }

        @Override
        public void execute(PackageApplication packageApplication) {
            packageApplication.setOutputFile(this.mOutputFile);
            packageApplication.inOldMode = AndroidGradleOptions.useOldPackaging(this.packagingScope.getProject());
            packageApplication.instantRunFileType = InstantRunBuildContext.FileType.RESOURCES;
            super.execute(packageApplication);
            packageApplication.dexPackagingPolicy = DexPackagingPolicy.STANDARD;
            for (String prop : ImmutableList.of((Object)"dexFolders", (Object)"jniFolders", (Object)"javaResourceFiles")) {
                ConventionMappingHelper.map((Task)packageApplication, prop, Collections::emptySet);
            }
            packageApplication.setSigningConfig(null);
        }
    }

    public static class StandardConfigAction
    extends PackageAndroidArtifact.ConfigAction<PackageApplication> {
        public StandardConfigAction(PackagingScope scope, InstantRunPatchingPolicy patchingPolicy) {
            super(scope, patchingPolicy);
        }

        @Override
        public String getName() {
            return this.packagingScope.getTaskName("package");
        }

        @Override
        public Class<PackageApplication> getType() {
            return PackageApplication.class;
        }

        @Override
        public void execute(PackageApplication packageApplication) {
            packageApplication.inOldMode = AndroidGradleOptions.useOldPackaging(this.packagingScope.getProject());
            ConventionMappingHelper.map((Task)packageApplication, "outputFile", packageApplication.inOldMode ? this.packagingScope::getIntermediateApk : this.packagingScope::getOutputApk);
            super.execute(packageApplication);
        }
    }
}

