/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.pipeline;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.TransformInput;
import com.android.build.gradle.internal.pipeline.StreamFilter;
import com.android.build.gradle.internal.pipeline.TransformStream;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Collection;
import java.util.Map;

public abstract class FilterableStreamCollection {
    abstract Collection<TransformStream> getStreams();

    public ImmutableList<TransformStream> getStreams(StreamFilter streamFilter) {
        ImmutableList.Builder streamsByType = ImmutableList.builder();
        for (TransformStream s : this.getStreams()) {
            if (!streamFilter.accept(s.getContentTypes(), s.getScopes())) continue;
            streamsByType.add((Object)s);
        }
        return streamsByType.build();
    }

    public Map<File, Format> getPipelineOutput(StreamFilter streamFilter) {
        ImmutableList<TransformStream> streams = this.getStreams(streamFilter);
        if (streams.isEmpty()) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (TransformStream stream : streams) {
            TransformInput input = stream.asNonIncrementalInput();
            for (JarInput jarInput : input.getJarInputs()) {
                builder.put((Object)jarInput.getFile(), (Object)Format.JAR);
            }
            for (DirectoryInput directoryInput : input.getDirectoryInputs()) {
                builder.put((Object)directoryInput.getFile(), (Object)Format.DIRECTORY);
            }
        }
        return builder.build();
    }
}

