/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.model;

import com.android.build.gradle.internal.model.LibraryImpl;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.Library;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class AndroidLibraryImpl
extends LibraryImpl
implements AndroidLibrary,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String variant;
    private final File bundle;
    private final File folder;
    private final File manifest;
    private final File jarFile;
    private final File resFolder;
    private final File assetsFolder;
    private final File jniFolder;
    private final File aidlFolder;
    private final File renderscriptFolder;
    private final File proguardRules;
    private final File lintJar;
    private final File annotations;
    private final File publicResources;
    private final File symbolFile;
    private final List<AndroidLibrary> androidLibraries;
    private final Collection<JavaLibrary> javaLibraries;
    private final Collection<File> localJars;

    AndroidLibraryImpl(AndroidLibrary clonedLibrary, List<AndroidLibrary> androidLibraries, Collection<JavaLibrary> javaLibraries, Collection<File> localJavaLibraries) {
        super((Library)clonedLibrary);
        this.androidLibraries = ImmutableList.copyOf(androidLibraries);
        this.javaLibraries = ImmutableList.copyOf(javaLibraries);
        this.localJars = ImmutableList.copyOf(localJavaLibraries);
        this.variant = clonedLibrary.getProjectVariant();
        this.bundle = clonedLibrary.getBundle();
        this.folder = clonedLibrary.getFolder();
        this.manifest = clonedLibrary.getManifest();
        this.jarFile = clonedLibrary.getJarFile();
        this.resFolder = clonedLibrary.getResFolder();
        this.assetsFolder = clonedLibrary.getAssetsFolder();
        this.jniFolder = clonedLibrary.getJniFolder();
        this.aidlFolder = clonedLibrary.getAidlFolder();
        this.renderscriptFolder = clonedLibrary.getRenderscriptFolder();
        this.proguardRules = clonedLibrary.getProguardRules();
        this.lintJar = clonedLibrary.getLintJar();
        this.annotations = clonedLibrary.getExternalAnnotations();
        this.publicResources = clonedLibrary.getPublicResources();
        this.symbolFile = clonedLibrary.getSymbolFile();
    }

    public String getProjectVariant() {
        return this.variant;
    }

    public File getBundle() {
        return this.bundle;
    }

    public File getFolder() {
        return this.folder;
    }

    public List<? extends AndroidLibrary> getLibraryDependencies() {
        return this.androidLibraries;
    }

    public Collection<? extends JavaLibrary> getJavaDependencies() {
        return this.javaLibraries;
    }

    public Collection<File> getLocalJars() {
        return this.localJars;
    }

    public File getManifest() {
        return this.manifest;
    }

    public File getJarFile() {
        return this.jarFile;
    }

    public File getResFolder() {
        return this.resFolder;
    }

    public File getAssetsFolder() {
        return this.assetsFolder;
    }

    public File getJniFolder() {
        return this.jniFolder;
    }

    public File getAidlFolder() {
        return this.aidlFolder;
    }

    public File getRenderscriptFolder() {
        return this.renderscriptFolder;
    }

    public File getProguardRules() {
        return this.proguardRules;
    }

    public File getLintJar() {
        return this.lintJar;
    }

    public File getExternalAnnotations() {
        return this.annotations;
    }

    public File getPublicResources() {
        return this.publicResources;
    }

    @Deprecated
    public boolean isOptional() {
        return this.isProvided();
    }

    public File getSymbolFile() {
        return this.symbolFile;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AndroidLibraryImpl that = (AndroidLibraryImpl)o;
        return Objects.equal((Object)this.variant, (Object)that.variant) && Objects.equal((Object)this.bundle, (Object)that.bundle) && Objects.equal((Object)this.folder, (Object)that.folder) && Objects.equal((Object)this.manifest, (Object)that.manifest) && Objects.equal((Object)this.jarFile, (Object)that.jarFile) && Objects.equal((Object)this.resFolder, (Object)that.resFolder) && Objects.equal((Object)this.assetsFolder, (Object)that.assetsFolder) && Objects.equal((Object)this.jniFolder, (Object)that.jniFolder) && Objects.equal((Object)this.aidlFolder, (Object)that.aidlFolder) && Objects.equal((Object)this.renderscriptFolder, (Object)that.renderscriptFolder) && Objects.equal((Object)this.proguardRules, (Object)that.proguardRules) && Objects.equal((Object)this.lintJar, (Object)that.lintJar) && Objects.equal((Object)this.annotations, (Object)that.annotations) && Objects.equal((Object)this.publicResources, (Object)that.publicResources) && Objects.equal((Object)this.symbolFile, (Object)that.symbolFile) && Objects.equal(this.androidLibraries, that.androidLibraries) && Objects.equal(this.javaLibraries, that.javaLibraries) && Objects.equal(this.localJars, that.localJars);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.variant, this.bundle, this.folder, this.manifest, this.jarFile, this.resFolder, this.assetsFolder, this.jniFolder, this.aidlFolder, this.renderscriptFolder, this.proguardRules, this.lintJar, this.annotations, this.publicResources, this.symbolFile, this.androidLibraries, this.javaLibraries, this.localJars});
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("project", (Object)this.getProject()).add("variant", (Object)this.variant).add("requestedCoordinates", (Object)this.getRequestedCoordinates()).add("resolvedCoordinates", (Object)this.getResolvedCoordinates()).add("bundle", (Object)this.bundle).add("folder", (Object)this.folder).add("manifest", (Object)this.manifest).add("jarFile", (Object)this.jarFile).add("resFolder", (Object)this.resFolder).add("assetsFolder", (Object)this.assetsFolder).add("jniFolder", (Object)this.jniFolder).add("aidlFolder", (Object)this.aidlFolder).add("renderscriptFolder", (Object)this.renderscriptFolder).add("proguardRules", (Object)this.proguardRules).add("lintJar", (Object)this.lintJar).add("annotations", (Object)this.annotations).add("publicResources", (Object)this.publicResources).add("symbolFile", (Object)this.symbolFile).add("androidLibraries", this.androidLibraries).add("javaLibraries", this.javaLibraries).add("localJars", this.localJars).add("super", (Object)super.toString()).toString();
    }
}

