/*
 * Decompiled with CFR 0.152.
 */
package com.google.devrel.gmscore.tools.apk.arsc;

import com.google.common.base.Preconditions;
import com.google.devrel.gmscore.tools.apk.arsc.Chunk;
import com.google.devrel.gmscore.tools.apk.arsc.XmlAttribute;
import com.google.devrel.gmscore.tools.apk.arsc.XmlNodeChunk;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public final class XmlStartElementChunk
extends XmlNodeChunk {
    private final int namespace;
    private final int name;
    private final int attributeStart;
    private final int attributeCount;
    private final int idIndex;
    private final int classIndex;
    private final int styleIndex;
    private final List<XmlAttribute> attributes = new ArrayList<XmlAttribute>();

    protected XmlStartElementChunk(ByteBuffer buffer, @Nullable Chunk parent) {
        super(buffer, parent);
        this.namespace = buffer.getInt();
        this.name = buffer.getInt();
        this.attributeStart = buffer.getShort() & 0xFFFF;
        int attributeSize = buffer.getShort() & 0xFFFF;
        Preconditions.checkState((attributeSize == 20 ? 1 : 0) != 0, (String)"attributeSize is wrong size. Got %s, want %s", (Object[])new Object[]{attributeSize, 20});
        this.attributeCount = buffer.getShort() & 0xFFFF;
        this.idIndex = (buffer.getShort() & 0xFFFF) - 1;
        this.classIndex = (buffer.getShort() & 0xFFFF) - 1;
        this.styleIndex = (buffer.getShort() & 0xFFFF) - 1;
    }

    @Override
    protected void init(ByteBuffer buffer) {
        super.init(buffer);
        this.attributes.addAll(this.enumerateAttributes(buffer));
    }

    private List<XmlAttribute> enumerateAttributes(ByteBuffer buffer) {
        int offset;
        ArrayList<XmlAttribute> result = new ArrayList<XmlAttribute>(this.attributeCount);
        int endOffset = offset + 20 * this.attributeCount;
        buffer.mark();
        buffer.position(offset);
        for (offset = this.offset + this.getHeaderSize() + this.attributeStart; offset < endOffset; offset += 20) {
            result.add(XmlAttribute.create(buffer, this));
        }
        buffer.reset();
        return result;
    }

    public String getNamespace() {
        return this.getString(this.namespace);
    }

    public String getName() {
        return this.getString(this.name);
    }

    public List<XmlAttribute> getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    @Override
    protected Chunk.Type getType() {
        return Chunk.Type.XML_START_ELEMENT;
    }

    @Override
    protected void writePayload(DataOutput output, ByteBuffer header, boolean shrink) throws IOException {
        super.writePayload(output, header, shrink);
        output.writeInt(this.namespace);
        output.writeInt(this.name);
        output.writeShort(20);
        output.writeShort(20);
        output.writeShort((short)this.attributes.size());
        output.writeShort((short)(this.idIndex + 1));
        output.writeShort((short)(this.classIndex + 1));
        output.writeShort((short)(this.styleIndex + 1));
        for (XmlAttribute attribute : this.attributes) {
            output.write(attribute.toByteArray(shrink));
        }
    }

    @Override
    public String toString() {
        return String.format("XmlStartElementChunk{line=%d, comment=%s, namespace=%s, name=%s, attributes=%s}", this.getLineNumber(), this.getComment(), this.getNamespace(), this.getName(), this.attributes.toString());
    }
}

