/*
 * Decompiled with CFR 0.152.
 */
package com.google.devrel.gmscore.tools.apk.arsc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.devrel.gmscore.tools.apk.arsc.Chunk;
import com.google.devrel.gmscore.tools.apk.arsc.ChunkWithChunks;
import com.google.devrel.gmscore.tools.apk.arsc.PackageUtils;
import com.google.devrel.gmscore.tools.apk.arsc.StringPoolChunk;
import com.google.devrel.gmscore.tools.apk.arsc.TypeChunk;
import com.google.devrel.gmscore.tools.apk.arsc.TypeSpecChunk;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public final class PackageChunk
extends ChunkWithChunks {
    private static final int TYPE_OFFSET_OFFSET = 268;
    private static final int KEY_OFFSET_OFFSET = 276;
    private final int id;
    private final String packageName;
    private final int typeStringsOffset;
    private final int lastPublicType;
    private final int keyStringsOffset;
    private final int lastPublicKey;
    private final int typeIdOffset;
    private final Map<Integer, TypeSpecChunk> typeSpecs = new HashMap<Integer, TypeSpecChunk>();
    private final Multimap<Integer, TypeChunk> types = ArrayListMultimap.create();

    protected PackageChunk(ByteBuffer buffer, @Nullable Chunk parent) {
        super(buffer, parent);
        this.id = buffer.getInt();
        this.packageName = PackageUtils.readPackageName(buffer, buffer.position());
        this.typeStringsOffset = buffer.getInt();
        this.lastPublicType = buffer.getInt();
        this.keyStringsOffset = buffer.getInt();
        this.lastPublicKey = buffer.getInt();
        this.typeIdOffset = buffer.getInt();
    }

    @Override
    protected void init(ByteBuffer buffer) {
        super.init(buffer);
        for (Chunk chunk : this.getChunks().values()) {
            if (chunk instanceof TypeChunk) {
                TypeChunk typeChunk = (TypeChunk)chunk;
                this.types.put((Object)typeChunk.getId(), (Object)typeChunk);
                continue;
            }
            if (chunk instanceof TypeSpecChunk) {
                TypeSpecChunk typeSpecChunk = (TypeSpecChunk)chunk;
                this.typeSpecs.put(typeSpecChunk.getId(), typeSpecChunk);
                continue;
            }
            if (chunk instanceof StringPoolChunk) continue;
            throw new IllegalStateException(String.format("PackageChunk contains an unexpected chunk: %s", chunk.getClass()));
        }
    }

    public int getId() {
        return this.id;
    }

    public StringPoolChunk getKeyStringPool() {
        Chunk chunk = (Chunk)Preconditions.checkNotNull((Object)this.getChunks().get(this.keyStringsOffset + this.offset));
        Preconditions.checkState((boolean)(chunk instanceof StringPoolChunk), (Object)"Key string pool not found.");
        return (StringPoolChunk)chunk;
    }

    public StringPoolChunk getTypeStringPool() {
        Chunk chunk = (Chunk)Preconditions.checkNotNull((Object)this.getChunks().get(this.typeStringsOffset + this.offset));
        Preconditions.checkState((boolean)(chunk instanceof StringPoolChunk), (Object)"Type string pool not found.");
        return (StringPoolChunk)chunk;
    }

    public Collection<TypeChunk> getTypeChunks() {
        return this.types.values();
    }

    public Collection<TypeChunk> getTypeChunks(int id) {
        return this.types.get((Object)id);
    }

    public Collection<TypeChunk> getTypeChunks(String type) {
        StringPoolChunk typeStringPool = (StringPoolChunk)Preconditions.checkNotNull((Object)this.getTypeStringPool());
        return this.getTypeChunks(typeStringPool.indexOf(type) + 1);
    }

    public Collection<TypeSpecChunk> getTypeSpecChunks() {
        return this.typeSpecs.values();
    }

    public TypeSpecChunk getTypeSpecChunk(int id) {
        return (TypeSpecChunk)Preconditions.checkNotNull((Object)this.typeSpecs.get(id));
    }

    public TypeSpecChunk getTypeSpecChunk(String type) {
        StringPoolChunk typeStringPool = (StringPoolChunk)Preconditions.checkNotNull((Object)this.getTypeStringPool());
        return this.getTypeSpecChunk(typeStringPool.indexOf(type) + 1);
    }

    public String getPackageName() {
        return this.packageName;
    }

    @Override
    protected Chunk.Type getType() {
        return Chunk.Type.TABLE_PACKAGE;
    }

    @Override
    protected void writeHeader(ByteBuffer output) {
        output.putInt(this.id);
        PackageUtils.writePackageName(output, this.packageName);
        output.putInt(0);
        output.putInt(this.lastPublicType);
        output.putInt(0);
        output.putInt(this.lastPublicKey);
        output.putInt(this.typeIdOffset);
    }

    @Override
    protected void writePayload(DataOutput output, ByteBuffer header, boolean shrink) throws IOException {
        int typeOffset = this.typeStringsOffset;
        int keyOffset = this.keyStringsOffset;
        int payloadOffset = 0;
        for (Chunk chunk : this.getChunks().values()) {
            if (chunk == this.getTypeStringPool()) {
                typeOffset = payloadOffset + this.getHeaderSize();
            } else if (chunk == this.getKeyStringPool()) {
                keyOffset = payloadOffset + this.getHeaderSize();
            }
            byte[] chunkBytes = chunk.toByteArray(shrink);
            output.write(chunkBytes);
            payloadOffset = this.writePad(output, chunkBytes.length);
        }
        header.putInt(268, typeOffset);
        header.putInt(276, keyOffset);
    }
}

