/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rpclib.schema;

import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import com.android.tools.rpclib.schema.Method;
import com.android.tools.rpclib.schema.Type;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class Primitive
extends Type {
    String mName;
    Method mMethod;

    public Primitive(String name, Method method) {
        this.mName = name;
        this.mMethod = method;
    }

    public Primitive(@NotNull Decoder d, Method method) throws IOException {
        this.mMethod = method;
        this.mName = d.nonCompactString();
    }

    @Override
    public String toString() {
        return this.mName + "(" + this.mMethod + ")";
    }

    public Method getMethod() {
        return this.mMethod;
    }

    @Override
    public void encodeValue(@NotNull Encoder e, Object value) throws IOException {
        switch (this.mMethod.getValue()) {
            case 0: {
                e.bool((Boolean)value);
                break;
            }
            case 1: {
                e.int8(((Number)value).byteValue());
                break;
            }
            case 2: {
                e.uint8(((Number)value).shortValue());
                break;
            }
            case 3: {
                e.int16(((Number)value).shortValue());
                break;
            }
            case 4: {
                e.uint16(((Number)value).intValue());
                break;
            }
            case 5: {
                e.int32(((Number)value).intValue());
                break;
            }
            case 6: {
                e.uint32(((Number)value).longValue());
                break;
            }
            case 7: {
                e.int64(((Number)value).longValue());
                break;
            }
            case 8: {
                e.uint64(((Number)value).longValue());
                break;
            }
            case 9: {
                e.float32(((Number)value).floatValue());
                break;
            }
            case 10: {
                e.float64(((Number)value).doubleValue());
                break;
            }
            case 11: {
                e.string(value == null ? null : value.toString());
                break;
            }
            default: {
                throw new IOException("Invalid primitive method in encode");
            }
        }
    }

    @Override
    public Object decodeValue(@NotNull Decoder d) throws IOException {
        switch (this.mMethod.getValue()) {
            case 0: {
                return d.bool();
            }
            case 1: {
                return d.int8();
            }
            case 2: {
                return d.uint8();
            }
            case 3: {
                return d.int16();
            }
            case 4: {
                return d.uint16();
            }
            case 5: {
                return d.int32();
            }
            case 6: {
                return d.uint32();
            }
            case 7: {
                return d.int64();
            }
            case 8: {
                return d.uint64();
            }
            case 9: {
                return Float.valueOf(d.float32());
            }
            case 10: {
                return d.float64();
            }
            case 11: {
                return d.string();
            }
        }
        throw new IOException("Invalid primitive method in decode");
    }

    @Override
    public void encode(@NotNull Encoder e) throws IOException {
        e.uint8((short)(0 | this.mMethod.getValue() << 4));
        e.nonCompactString(this.mName);
    }

    @Override
    void name(StringBuilder out) {
        out.append(this.mName);
    }

    @Override
    public void signature(StringBuilder out) {
        out.append(this.mMethod);
    }

    public static boolean isMethod(Type ty, Method method) {
        if (!(ty instanceof Primitive)) {
            return false;
        }
        return ((Primitive)ty).mMethod.equals(method);
    }
}

