/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rpclib.schema;

import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class Method {
    public static final Method Bool = new Method(0, "Bool");
    public static final byte BoolValue = 0;
    public static final Method Int8 = new Method(1, "Int8");
    public static final byte Int8Value = 1;
    public static final Method Uint8 = new Method(2, "Uint8");
    public static final byte Uint8Value = 2;
    public static final Method Int16 = new Method(3, "Int16");
    public static final byte Int16Value = 3;
    public static final Method Uint16 = new Method(4, "Uint16");
    public static final byte Uint16Value = 4;
    public static final Method Int32 = new Method(5, "Int32");
    public static final byte Int32Value = 5;
    public static final Method Uint32 = new Method(6, "Uint32");
    public static final byte Uint32Value = 6;
    public static final Method Int64 = new Method(7, "Int64");
    public static final byte Int64Value = 7;
    public static final Method Uint64 = new Method(8, "Uint64");
    public static final byte Uint64Value = 8;
    public static final Method Float32 = new Method(9, "Float32");
    public static final byte Float32Value = 9;
    public static final Method Float64 = new Method(10, "Float64");
    public static final byte Float64Value = 10;
    public static final Method String = new Method(11, "String");
    public static final byte StringValue = 11;
    private static final ImmutableMap<Byte, Method> VALUES = ImmutableMap.builder().put((Object)0, (Object)Bool).put((Object)1, (Object)Int8).put((Object)2, (Object)Uint8).put((Object)3, (Object)Int16).put((Object)4, (Object)Uint16).put((Object)5, (Object)Int32).put((Object)6, (Object)Uint32).put((Object)7, (Object)Int64).put((Object)8, (Object)Uint64).put((Object)9, (Object)Float32).put((Object)10, (Object)Float64).put((Object)11, (Object)String).build();
    private final byte mValue;
    private final String mName;

    private Method(byte v, String n) {
        this.mValue = v;
        this.mName = n;
    }

    public byte getValue() {
        return this.mValue;
    }

    public String getName() {
        return this.mName;
    }

    public void encode(@NotNull Encoder e) throws IOException {
        e.uint8(this.mValue);
    }

    public static Method decode(@NotNull Decoder d) throws IOException {
        return Method.findOrCreate(d.uint8());
    }

    public static Method find(byte value) {
        return (Method)VALUES.get((Object)value);
    }

    public static Method findOrCreate(byte value) {
        Method result = (Method)VALUES.get((Object)value);
        return result == null ? new Method(value, null) : result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Method)) {
            return false;
        }
        return this.mValue == ((Method)o).mValue;
    }

    public int hashCode() {
        return this.mValue;
    }

    public String toString() {
        return this.mName == null ? "Method(" + this.mValue + ")" : this.mName;
    }
}

