/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rpclib.schema;

import com.android.tools.rpclib.binary.BinaryClass;
import com.android.tools.rpclib.binary.BinaryObject;
import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import com.android.tools.rpclib.binary.Namespace;
import com.android.tools.rpclib.schema.Entity;
import com.android.tools.rpclib.schema.Field;
import java.io.IOException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class Dynamic
implements BinaryObject {
    private Klass mKlass;
    private Object[] mFields;

    public Dynamic(Klass klass) {
        this.mKlass = klass;
    }

    public Entity type() {
        return this.mKlass.mType;
    }

    public static BinaryClass register(Entity type) {
        Klass klass = new Klass(type);
        Namespace.register(klass);
        return klass;
    }

    public int getFieldCount() {
        return this.mFields.length;
    }

    public Field getFieldInfo(int index) {
        return this.mKlass.mType.getFields()[index];
    }

    public Object getFieldValue(int index) {
        return this.mFields[index];
    }

    public void setFieldValue(int index, Object value) {
        this.mFields[index] = value;
    }

    public Dynamic copy() {
        Dynamic result = new Dynamic(this.mKlass);
        result.mFields = Arrays.copyOf(this.mFields, this.mFields.length);
        return result;
    }

    @Override
    @NotNull
    public Klass klass() {
        return this.mKlass;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Dynamic)) {
            return false;
        }
        Dynamic d = (Dynamic)obj;
        return this.type().equals(d.type()) && Arrays.deepEquals(this.mFields, d.mFields);
    }

    public int hashCode() {
        return this.mKlass.hashCode() + 31 * Arrays.deepHashCode(this.mFields);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.mKlass.entity().getName()).append('{');
        Field[] fields = this.mKlass.entity().getFields();
        for (int i = 0; i < this.mFields.length; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            String fieldsString = this.mFields[i] instanceof Object[] ? Arrays.toString((Object[])this.mFields[i]) : String.valueOf(this.mFields[i]);
            result.append(fields[i].getName()).append(": ").append(fieldsString);
        }
        result.append('}');
        return result.toString();
    }

    static /* synthetic */ Object[] access$202(Dynamic x0, Object[] x1) {
        x0.mFields = x1;
        return x1;
    }

    public static class Klass
    implements BinaryClass {
        private Entity mType;

        Klass(Entity type) {
            this.mType = type;
        }

        @Override
        @NotNull
        public Entity entity() {
            return this.mType;
        }

        @Override
        @NotNull
        public BinaryObject create() {
            return new Dynamic(this);
        }

        @Override
        public void encode(@NotNull Encoder e, BinaryObject obj) throws IOException {
            Dynamic o = (Dynamic)obj;
            assert (o.mKlass == this);
            for (int i = 0; i < this.mType.getFields().length; ++i) {
                Field field = this.mType.getFields()[i];
                Object value = o.mFields[i];
                field.getType().encodeValue(e, value);
            }
        }

        @Override
        public void decode(@NotNull Decoder d, BinaryObject obj) throws IOException {
            Dynamic o = (Dynamic)obj;
            Dynamic.access$202(o, new Object[this.mType.getFields().length]);
            for (int i = 0; i < this.mType.getFields().length; ++i) {
                Field field = this.mType.getFields()[i];
                ((Dynamic)o).mFields[i] = field.getType().decodeValue(d);
            }
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Klass)) {
                return false;
            }
            return this.entity().equals(((Klass)obj).entity());
        }

        public int hashCode() {
            return this.mType.hashCode();
        }
    }
}

