/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rpclib.rpccore;

import com.android.tools.rpclib.futures.FutureController;
import com.android.tools.rpclib.rpccore.RpcException;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Uninterruptibles;
import com.intellij.openapi.diagnostic.Logger;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Rpc {
    private static final Executor EXECUTOR = MoreExecutors.sameThreadExecutor();

    public static <V> V get(ListenableFuture<V> future, long timeout, TimeUnit unit) throws RpcException, TimeoutException, ExecutionException {
        try {
            return (V)Uninterruptibles.getUninterruptibly(future, (long)timeout, (TimeUnit)unit);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (!(cause instanceof RpcException)) {
                throw e;
            }
            throw (RpcException)cause;
        }
    }

    public static <V> void listen(ListenableFuture<V> future, Logger log, Callback<V> callback) {
        Rpc.listen(future, log, FutureController.NULL_CONTROLLER, callback);
    }

    public static <V> void listen(final ListenableFuture<V> future, final Logger log, final FutureController controller, final Callback<V> callback) {
        controller.onStart((Future<?>)future);
        future.addListener(new Runnable(){

            @Override
            public void run() {
                if (!controller.onStop((Future<?>)future)) {
                    return;
                }
                try {
                    callback.onFinish(new Result(future));
                }
                catch (CancellationException cancellationException) {
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
        }, EXECUTOR);
    }

    public static class Result<V> {
        private final ListenableFuture<V> mFuture;

        private Result(ListenableFuture<V> future) {
            this.mFuture = future;
        }

        public V get() throws RpcException, ExecutionException {
            try {
                return (V)Uninterruptibles.getUninterruptibly(this.mFuture);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof RpcException)) {
                    throw e;
                }
                throw (RpcException)cause;
            }
        }
    }

    public static interface Callback<V> {
        public void onFinish(Result<V> var1) throws RpcException, ExecutionException;
    }
}

