/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rpclib.rpccore;

import com.android.tools.rpclib.binary.BinaryObject;
import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import com.android.tools.rpclib.multiplex.Channel;
import com.android.tools.rpclib.multiplex.Multiplexer;
import com.android.tools.rpclib.rpccore.RpcException;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;

public class Broadcaster {
    private final Multiplexer mMultiplexer;
    private final int mMtu;
    private final int mVersion;

    public Broadcaster(@NotNull InputStream in, @NotNull OutputStream out, int mtu, @NotNull ExecutorService executorService, int version) {
        this.mMultiplexer = new Multiplexer(in, out, mtu, executorService, null);
        this.mMtu = mtu;
        this.mVersion = version;
    }

    private void writeHeader(@NotNull Encoder encoder) throws IOException {
        encoder.int8((byte)114);
        encoder.int8((byte)112);
        encoder.int8((byte)99);
        encoder.int8((byte)(this.mVersion < 2 ? 48 : 49));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BinaryObject Send(@NotNull BinaryObject call) throws IOException, RpcException {
        try (Channel channel = this.mMultiplexer.openChannel();){
            BufferedOutputStream out = new BufferedOutputStream(channel.getOutputStream(), this.mMtu);
            Encoder e = new Encoder(out);
            Decoder d = new Decoder(channel.getInputStream());
            this.writeHeader(e);
            e.object(call);
            out.flush();
            BinaryObject res = d.object();
            if (res instanceof RpcException) {
                throw (RpcException)((Object)res);
            }
            BinaryObject binaryObject = res;
            return binaryObject;
        }
    }
}

