/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap.hprof;

import com.android.tools.perflib.heap.hprof.HprofOutputStream;
import com.android.tools.perflib.heap.hprof.HprofRecord;
import java.io.IOException;

public class HprofStackTrace
implements HprofRecord {
    public static final byte TAG = 5;
    public final int time;
    public final int stackTraceSerialNumber;
    public final int threadSerialNumber;
    public final long[] stackFrameIds;

    public HprofStackTrace(int time, int stackTraceSerialNumber, int threadSerialNumber, long[] stackFrameIds) {
        this.time = time;
        this.stackTraceSerialNumber = stackTraceSerialNumber;
        this.threadSerialNumber = threadSerialNumber;
        this.stackFrameIds = stackFrameIds;
    }

    @Override
    public void write(HprofOutputStream hprof) throws IOException {
        int id = hprof.getIdSize();
        int u4 = 4;
        hprof.writeRecordHeader((byte)5, this.time, u4 + u4 + u4 + this.stackFrameIds.length * id);
        hprof.writeU4(this.stackTraceSerialNumber);
        hprof.writeU4(this.threadSerialNumber);
        hprof.writeU4(this.stackFrameIds.length);
        for (long frameId : this.stackFrameIds) {
            hprof.writeId(frameId);
        }
    }
}

