/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

public class TrustAllX509TrustManagerDetector
extends Detector
implements Detector.JavaPsiScanner,
Detector.ClassScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(TrustAllX509TrustManagerDetector.class, EnumSet.of(Scope.JAVA_LIBRARIES, Scope.JAVA_FILE), Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("TrustAllX509TrustManager", "Insecure TLS/SSL trust manager", "This check looks for X509TrustManager implementations whose `checkServerTrusted` or `checkClientTrusted` methods do nothing (thus trusting any certificate chain) which could result in insecure network traffic caused by trusting arbitrary TLS/SSL certificates presented by peers.", Category.SECURITY, 6, Severity.WARNING, IMPLEMENTATION);

    @Override
    public List<String> applicableSuperClasses() {
        return Collections.singletonList("javax.net.ssl.X509TrustManager");
    }

    @Override
    public void checkClass(JavaContext context, PsiClass cls) {
        TrustAllX509TrustManagerDetector.checkMethod(context, cls, "checkServerTrusted");
        TrustAllX509TrustManagerDetector.checkMethod(context, cls, "checkClientTrusted");
    }

    private static void checkMethod(JavaContext context, PsiClass cls, String methodName) {
        JavaEvaluator evaluator = context.getEvaluator();
        for (PsiMethod method : cls.findMethodsByName(methodName, true)) {
            if (evaluator.isAbstract((PsiModifierListOwner)method)) continue;
            boolean complex = false;
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return;
            }
            for (PsiStatement statement : body.getStatements()) {
                if (statement instanceof PsiReturnStatement) continue;
                complex = true;
                break;
            }
            if (complex) continue;
            Location location = context.getNameLocation((PsiElement)method);
            String message = TrustAllX509TrustManagerDetector.getErrorMessage(methodName);
            context.report(ISSUE, (PsiElement)method, location, message);
        }
    }

    private static String getErrorMessage(String methodName) {
        return "`" + methodName + "` is empty, which could cause " + "insecure network traffic due to trusting arbitrary TLS/SSL " + "certificates presented by peers";
    }

    @Override
    public void checkClass(ClassContext context, ClassNode classNode) {
        if (!context.isFromClassLibrary()) {
            return;
        }
        if (!classNode.interfaces.contains("javax/net/ssl/X509TrustManager")) {
            return;
        }
        List methodList = classNode.methods;
        for (Object m : methodList) {
            MethodNode method = (MethodNode)m;
            if (!"checkServerTrusted".equals(method.name) && !"checkClientTrusted".equals(method.name)) continue;
            InsnList nodes = method.instructions;
            boolean emptyMethod = true;
            int n = nodes.size();
            for (int i = 0; i < n; ++i) {
                AbstractInsnNode instruction = nodes.get(i);
                int type = instruction.getType();
                if (type == 8 || type == 15 || type == 0 && instruction.getOpcode() == 177) continue;
                emptyMethod = false;
                break;
            }
            if (!emptyMethod) continue;
            Location location = context.getLocation(method, classNode);
            context.report(ISSUE, location, TrustAllX509TrustManagerDetector.getErrorMessage(method.name));
        }
    }
}

