/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceContext;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.SdkUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class ResourcePrefixDetector
extends ResourceXmlDetector
implements Detector.BinaryResourceScanner {
    public static final Issue ISSUE = Issue.create("ResourceName", "Resource with Wrong Prefix", "In Gradle projects you can specify a resource prefix that all resources in the project must conform to. This makes it easier to ensure that you don't accidentally combine resources from different libraries, since they all end up in the same shared app namespace.", Category.CORRECTNESS, 8, Severity.FATAL, new Implementation(ResourcePrefixDetector.class, EnumSet.of(Scope.RESOURCE_FILE, Scope.BINARY_RESOURCE_FILE), Scope.RESOURCE_FILE_SCOPE, Scope.BINARY_RESOURCE_FILE_SCOPE));
    private String mPrefix;

    @Override
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public boolean appliesTo(Context context, File file) {
        return true;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("resources", "declare-styleable");
    }

    private static String computeResourcePrefix(Project project) {
        if (project.isGradleProject()) {
            return LintUtils.computeResourcePrefix(project.getGradleProjectModel());
        }
        return null;
    }

    @Override
    public void beforeCheckProject(Context context) {
        this.mPrefix = ResourcePrefixDetector.computeResourcePrefix(context.getProject());
    }

    @Override
    public void beforeCheckLibraryProject(Context context) {
        this.mPrefix = ResourcePrefixDetector.computeResourcePrefix(context.getProject());
    }

    @Override
    public void afterCheckProject(Context context) {
        this.mPrefix = null;
    }

    @Override
    public void afterCheckLibraryProject(Context context) {
        this.mPrefix = null;
    }

    @Override
    public void beforeCheckFile(Context context) {
        String name;
        XmlContext xmlContext;
        ResourceFolderType folderType;
        if (this.mPrefix != null && context instanceof XmlContext && (folderType = (xmlContext = (XmlContext)context).getResourceFolderType()) != null && folderType != ResourceFolderType.VALUES && !(name = LintUtils.getBaseName(context.file.getName())).startsWith(this.mPrefix)) {
            Element root;
            if (xmlContext.document != null && (root = xmlContext.document.getDocumentElement()) != null) {
                xmlContext.report(ISSUE, root, xmlContext.getLocation(root), this.getErrorMessage(name));
                return;
            }
            context.report(ISSUE, Location.create(context.file), this.getErrorMessage(name));
        }
    }

    private String getErrorMessage(String name) {
        assert (this.mPrefix != null && !name.startsWith(this.mPrefix));
        return String.format("Resource named '`%1$s`' does not start with the project's resource prefix '`%2$s`'; rename to '`%3$s`' ?", name, this.mPrefix, LintUtils.computeResourceName(this.mPrefix, name));
    }

    @Override
    public void visitElement(XmlContext context, Element element) {
        if (this.mPrefix == null || context.getResourceFolderType() != ResourceFolderType.VALUES) {
            return;
        }
        for (Element item : LintUtils.getChildren(element)) {
            String tagName;
            String name;
            Attr nameAttribute = item.getAttributeNode("name");
            if (nameAttribute == null || (name = nameAttribute.getValue()).startsWith(this.mPrefix) || ((tagName = item.getTagName()).equals("declare-styleable") || tagName.equals("style")) && (SdkUtils.startsWithIgnoreCase((String)name, (String)this.mPrefix) || this.mPrefix.endsWith("_") && name.regionMatches(true, 0, this.mPrefix, 0, this.mPrefix.length() - 1)) || name.indexOf(58) != -1) continue;
            String message = this.getErrorMessage(name);
            context.report(ISSUE, nameAttribute, context.getLocation(nameAttribute), message);
        }
    }

    @Override
    public void checkBinaryResource(ResourceContext context) {
        String name;
        ResourceFolderType folderType;
        if (this.mPrefix != null && (folderType = context.getResourceFolderType()) != null && folderType != ResourceFolderType.VALUES && !(name = LintUtils.getBaseName(context.file.getName())).startsWith(this.mPrefix)) {
            String path = context.file.getPath();
            if (path.endsWith(".bc") && folderType == ResourceFolderType.RAW) {
                return;
            }
            Location location = Location.create(context.file);
            context.report(ISSUE, location, this.getErrorMessage(name));
        }
    }
}

