/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SourceProviderContainer;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.SdkUtils;
import com.google.common.collect.Maps;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class RegistrationDetector
extends LayoutDetector
implements Detector.JavaPsiScanner {
    public static final Issue ISSUE = Issue.create("Registered", "Class is not registered in the manifest", "Activities, services and content providers should be registered in the `AndroidManifest.xml` file using `<activity>`, `<service>` and `<provider>` tags.\n\nIf your activity is simply a parent class intended to be subclassed by other \"real\" activities, make it an abstract class.", Category.CORRECTNESS, 6, Severity.WARNING, new Implementation(RegistrationDetector.class, EnumSet.of(Scope.MANIFEST, Scope.JAVA_FILE))).addMoreInfo("http://developer.android.com/guide/topics/manifest/manifest-intro.html");
    protected Map<String, String> mManifestRegistrations;
    private static final String[] sTags = new String[]{"activity", "service", "receiver", "provider", "application"};
    private static final String[] sClasses = new String[]{"android.app.Activity", "android.app.Service", "android.content.BroadcastReceiver", "android.content.ContentProvider", "android.app.Application"};

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList(sTags);
    }

    @Override
    public void visitElement(XmlContext context, Element element) {
        if (!element.hasAttributeNS("http://schemas.android.com/apk/res/android", "name")) {
            return;
        }
        String fqcn = RegistrationDetector.getFqcn(context, element);
        String tag = element.getTagName();
        String frameworkClass = RegistrationDetector.tagToClass(tag);
        if (frameworkClass != null) {
            String signature = fqcn;
            if (this.mManifestRegistrations == null) {
                this.mManifestRegistrations = Maps.newHashMap();
            }
            this.mManifestRegistrations.put(signature, frameworkClass);
            if (signature.indexOf(36) != -1) {
                signature = signature.replace('$', '.');
                this.mManifestRegistrations.put(signature, frameworkClass);
            }
        }
    }

    private static String getFqcn(XmlContext context, Element element) {
        String className = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
        if (className.startsWith(".")) {
            return context.getProject().getPackage() + className;
        }
        if (className.indexOf(46) == -1) {
            return context.getProject().getPackage() + '.' + className;
        }
        return className;
    }

    @Override
    public List<String> applicableSuperClasses() {
        return Arrays.asList("android.content.ComponentCallbacks2", "android.content.BroadcastReceiver");
    }

    @Override
    public void checkClass(JavaContext context, PsiClass cls) {
        if (cls.getName() == null) {
            return;
        }
        JavaEvaluator evaluator = context.getEvaluator();
        if (evaluator.isAbstract((PsiModifierListOwner)cls) || evaluator.isPrivate((PsiModifierListOwner)cls)) {
            return;
        }
        String rightTag = RegistrationDetector.getTag(evaluator, cls);
        if (rightTag == null) {
            return;
        }
        String className = cls.getQualifiedName();
        if (className == null) {
            return;
        }
        if (this.mManifestRegistrations != null) {
            String framework = this.mManifestRegistrations.get(className);
            if (framework == null) {
                RegistrationDetector.reportMissing(context, cls, className, rightTag);
            } else if (!evaluator.extendsClass(cls, framework, false)) {
                RegistrationDetector.reportWrongTag(context, cls, rightTag, className, framework);
            }
        } else {
            RegistrationDetector.reportMissing(context, cls, className, rightTag);
        }
    }

    private static void reportWrongTag(JavaContext context, PsiClass node, String rightTag, String className, String framework) {
        String wrongTag = RegistrationDetector.classToTag(framework);
        if (wrongTag == null) {
            return;
        }
        Location location = context.getNameLocation((PsiElement)node);
        String message = String.format("`%1$s` is %2$s but is registered in the manifest as %3$s", className, RegistrationDetector.describeTag(rightTag), RegistrationDetector.describeTag(wrongTag));
        context.report(ISSUE, (PsiElement)node, location, message);
    }

    private static String describeTag(String tag) {
        String article = tag.startsWith("a") ? "an" : "a";
        return String.format("%1$s `<%2$s>`", article, tag);
    }

    private static void reportMissing(JavaContext context, PsiClass node, String className, String tag) {
        AndroidProject model;
        if (tag.equals("receiver")) {
            return;
        }
        if (context.getProject().isGradleProject() && (model = context.getProject().getGradleProjectModel()) != null) {
            String javaSource = context.file.getPath();
            for (SourceProviderContainer extra : model.getDefaultConfig().getExtraSourceProviders()) {
                String artifactName = extra.getArtifactName();
                if (!"_android_test_".equals(artifactName)) continue;
                for (File file : extra.getSourceProvider().getJavaDirectories()) {
                    if (!SdkUtils.startsWithIgnoreCase((String)javaSource, (String)file.getPath())) continue;
                    return;
                }
            }
            for (ProductFlavorContainer container : model.getProductFlavors()) {
                for (SourceProviderContainer extra : container.getExtraSourceProviders()) {
                    String artifactName = extra.getArtifactName();
                    if (!"_android_test_".equals(artifactName)) continue;
                    for (File file : extra.getSourceProvider().getJavaDirectories()) {
                        if (!SdkUtils.startsWithIgnoreCase((String)javaSource, (String)file.getPath())) continue;
                        return;
                    }
                }
            }
        }
        Location location = context.getNameLocation((PsiElement)node);
        String message = String.format("The `<%1$s> %2$s` is not registered in the manifest", tag, className);
        context.report(ISSUE, (PsiElement)node, location, message);
    }

    private static String getTag(JavaEvaluator evaluator, PsiClass cls) {
        String tag = null;
        for (String s : sClasses) {
            if (!evaluator.extendsClass(cls, s, false)) continue;
            tag = RegistrationDetector.classToTag(s);
            break;
        }
        return tag;
    }

    private static String tagToClass(String tag) {
        int n = sTags.length;
        for (int i = 0; i < n; ++i) {
            if (!sTags[i].equals(tag)) continue;
            return sClasses[i];
        }
        return null;
    }

    protected static String classToTag(String className) {
        int n = sClasses.length;
        for (int i = 0; i < n; ++i) {
            if (!sClasses[i].equals(className)) continue;
            return sTags[i];
        }
        return null;
    }
}

