/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.google.common.collect.Sets;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class JavaPerformanceDetector
extends Detector
implements Detector.JavaPsiScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(JavaPerformanceDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue PAINT_ALLOC = Issue.create("DrawAllocation", "Memory allocations within drawing code", "You should avoid allocating objects during a drawing or layout operation. These are called frequently, so a smooth UI can be interrupted by garbage collection pauses caused by the object allocations.\n\nThe way this is generally handled is to allocate the needed objects up front and to reuse them for each drawing operation.\n\nSome methods allocate memory on your behalf (such as `Bitmap.create`), and these should be handled in the same way.", Category.PERFORMANCE, 9, Severity.WARNING, IMPLEMENTATION);
    public static final Issue USE_SPARSE_ARRAY = Issue.create("UseSparseArrays", "HashMap can be replaced with SparseArray", "For maps where the keys are of type integer, it's typically more efficient to use the Android `SparseArray` API. This check identifies scenarios where you might want to consider using `SparseArray` instead of `HashMap` for better performance.\n\nThis is *particularly* useful when the value types are primitives like ints, where you can use `SparseIntArray` and avoid auto-boxing the values from `int` to `Integer`.\n\nIf you need to construct a `HashMap` because you need to call an API outside of your control which requires a `Map`, you can suppress this warning using for example the `@SuppressLint` annotation.", Category.PERFORMANCE, 4, Severity.WARNING, IMPLEMENTATION);
    public static final Issue USE_VALUE_OF = Issue.create("UseValueOf", "Should use `valueOf` instead of `new`", "You should not call the constructor for wrapper classes directly, such as`new Integer(42)`. Instead, call the `valueOf` factory method, such as `Integer.valueOf(42)`. This will typically use less memory because common integers such as 0 and 1 will share a single instance.", Category.PERFORMANCE, 4, Severity.WARNING, IMPLEMENTATION);
    static final String ON_MEASURE = "onMeasure";
    static final String ON_DRAW = "onDraw";
    static final String ON_LAYOUT = "onLayout";
    private static final String LAYOUT = "layout";
    private static final String HASH_MAP = "java.util.HashMap";
    private static final String SPARSE_ARRAY = "android.util.SparseArray";
    public static final String CLASS_CANVAS = "android.graphics.Canvas";

    @Override
    public List<Class<? extends PsiElement>> getApplicablePsiTypes() {
        ArrayList<Class<? extends PsiElement>> types = new ArrayList<Class<? extends PsiElement>>(3);
        types.add(PsiNewExpression.class);
        types.add(PsiMethod.class);
        types.add(PsiMethodCallExpression.class);
        return types;
    }

    @Override
    public JavaElementVisitor createPsiVisitor(JavaContext context) {
        return new PerformanceVisitor(context);
    }

    private static String getUseValueOfErrorMessage(String typeName, String argument) {
        return String.format("Use `%1$s.valueOf(%2$s)` instead", typeName.substring(typeName.lastIndexOf(46) + 1), argument);
    }

    public static String getReplacedType(String message, TextFormat format) {
        int index = (message = format.toText(message)).indexOf(46);
        if (index != -1 && message.startsWith("Use ")) {
            return message.substring(4, index);
        }
        return null;
    }

    private static class AssignmentTracker
    extends JavaRecursiveElementVisitor {
        private final Collection<String> mVariables;

        public AssignmentTracker(Collection<String> variables) {
            this.mVariables = variables;
        }

        public void visitAssignmentExpression(PsiAssignmentExpression node) {
            super.visitAssignmentExpression(node);
            PsiExpression left = node.getLExpression();
            if (left instanceof PsiReferenceExpression) {
                PsiReferenceExpression ref = (PsiReferenceExpression)left;
                if (ref.getQualifier() instanceof PsiThisExpression || ref.getQualifier() instanceof PsiSuperExpression) {
                    this.mVariables.add(ref.getReferenceName());
                } else {
                    this.mVariables.add(ref.getText());
                }
            } else if (left instanceof PsiIdentifier) {
                this.mVariables.add(left.getText());
            }
        }
    }

    private static class PerformanceVisitor
    extends JavaElementVisitor {
        private final JavaContext mContext;
        private final boolean mCheckMaps;
        private final boolean mCheckAllocations;
        private final boolean mCheckValueOf;
        private boolean mFlagAllocations;

        public PerformanceVisitor(JavaContext context) {
            this.mContext = context;
            this.mCheckAllocations = context.isEnabled(PAINT_ALLOC);
            this.mCheckMaps = context.isEnabled(USE_SPARSE_ARRAY);
            this.mCheckValueOf = context.isEnabled(USE_VALUE_OF);
        }

        public void visitMethod(PsiMethod node) {
            this.mFlagAllocations = this.isBlockedAllocationMethod(node);
        }

        public void visitNewExpression(PsiNewExpression node) {
            PsiMethod method;
            String typeName = null;
            PsiJavaCodeReferenceElement classReference = node.getClassReference();
            if ((this.mCheckMaps || this.mCheckValueOf) && classReference != null) {
                typeName = classReference.getQualifiedName();
            }
            if (this.mCheckMaps) {
                if (JavaPerformanceDetector.HASH_MAP.equals(typeName)) {
                    this.checkHashMap(node, classReference);
                } else if (JavaPerformanceDetector.SPARSE_ARRAY.equals(typeName)) {
                    this.checkSparseArray(node, classReference);
                }
            }
            if (this.mCheckValueOf && typeName != null && (typeName.equals("java.lang.Integer") || typeName.equals("java.lang.Boolean") || typeName.equals("java.lang.Float") || typeName.equals("java.lang.Character") || typeName.equals("java.lang.Long") || typeName.equals("java.lang.Double") || typeName.equals("java.lang.Byte")) && node.getArgumentList() != null && node.getArgumentList().getExpressions().length == 1) {
                String argument = node.getArgumentList().getExpressions()[0].getText();
                this.mContext.report(USE_VALUE_OF, (PsiElement)node, this.mContext.getLocation((PsiElement)node), JavaPerformanceDetector.getUseValueOfErrorMessage(typeName, argument));
            }
            if (this.mFlagAllocations && !(LintUtils.skipParentheses(node.getParent()) instanceof PsiThrowStatement) && this.mCheckAllocations && (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)node, PsiMethod.class)) != null && this.isBlockedAllocationMethod(method) && !PerformanceVisitor.isLazilyInitialized((PsiElement)node)) {
                this.reportAllocation((PsiElement)node);
            }
        }

        private void reportAllocation(PsiElement node) {
            this.mContext.report(PAINT_ALLOC, node, this.mContext.getLocation(node), "Avoid object allocations during draw/layout operations (preallocate and reuse instead)");
        }

        public void visitMethodCallExpression(PsiMethodCallExpression node) {
            if (!this.mFlagAllocations) {
                return;
            }
            PsiReferenceExpression expression = node.getMethodExpression();
            PsiElement qualifier = expression.getQualifier();
            if (qualifier == null) {
                return;
            }
            String methodName = expression.getReferenceName();
            if (methodName == null) {
                return;
            }
            if (methodName.equals("createBitmap") || methodName.equals("createScaledBitmap")) {
                PsiMethod method = node.resolveMethod();
                if (method != null && this.mContext.getEvaluator().isMemberInClass((PsiMember)method, "android.graphics.Bitmap") && !PerformanceVisitor.isLazilyInitialized((PsiElement)node)) {
                    this.reportAllocation((PsiElement)node);
                }
            } else if (methodName.startsWith("decode")) {
                PsiMethod method = node.resolveMethod();
                if (method != null && this.mContext.getEvaluator().isMemberInClass((PsiMember)method, "android.graphics.BitmapFactory") && !PerformanceVisitor.isLazilyInitialized((PsiElement)node)) {
                    this.reportAllocation((PsiElement)node);
                }
            } else if (methodName.equals("getClipBounds") && node.getArgumentList().getExpressions().length == 0) {
                this.mContext.report(PAINT_ALLOC, (PsiElement)node, this.mContext.getLocation((PsiElement)node), "Avoid object allocations during draw operations: Use `Canvas.getClipBounds(Rect)` instead of `Canvas.getClipBounds()` which allocates a temporary `Rect`");
            }
        }

        private static boolean isLazilyInitialized(PsiElement node) {
            for (PsiElement curr = node.getParent(); curr != null; curr = curr.getParent()) {
                if (curr instanceof PsiMethod) {
                    return false;
                }
                if (!(curr instanceof PsiIfStatement)) continue;
                PsiIfStatement ifNode = (PsiIfStatement)curr;
                ArrayList<String> assignments = new ArrayList<String>();
                AssignmentTracker visitor = new AssignmentTracker(assignments);
                if (ifNode.getThenBranch() != null) {
                    ifNode.getThenBranch().accept((PsiElementVisitor)visitor);
                }
                if (!assignments.isEmpty()) {
                    ArrayList<String> references = new ArrayList<String>();
                    PerformanceVisitor.addReferencedVariables(references, ifNode.getCondition());
                    if (!references.isEmpty()) {
                        Sets.SetView intersection = Sets.intersection(new HashSet<String>(assignments), new HashSet<String>(references));
                        return !intersection.isEmpty();
                    }
                }
                return false;
            }
            return false;
        }

        private static void addReferencedVariables(Collection<String> variables, PsiExpression expression) {
            if (expression instanceof PsiBinaryExpression) {
                PsiBinaryExpression binary = (PsiBinaryExpression)expression;
                PerformanceVisitor.addReferencedVariables(variables, binary.getLOperand());
                PerformanceVisitor.addReferencedVariables(variables, binary.getROperand());
            } else if (expression instanceof PsiPrefixExpression) {
                PsiPrefixExpression unary = (PsiPrefixExpression)expression;
                PerformanceVisitor.addReferencedVariables(variables, unary.getOperand());
            } else if (expression instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression exp = (PsiParenthesizedExpression)expression;
                PerformanceVisitor.addReferencedVariables(variables, exp.getExpression());
            } else if (expression instanceof PsiIdentifier) {
                PsiIdentifier reference = (PsiIdentifier)expression;
                variables.add(reference.getText());
            } else if (expression instanceof PsiReferenceExpression) {
                PsiReferenceExpression ref = (PsiReferenceExpression)expression;
                PsiElement qualifier = ref.getQualifier();
                if (qualifier != null) {
                    if (qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression) {
                        variables.add(ref.getReferenceName());
                    }
                } else {
                    variables.add(ref.getReferenceName());
                }
            }
        }

        private boolean isBlockedAllocationMethod(PsiMethod node) {
            JavaEvaluator evaluator = this.mContext.getEvaluator();
            return PerformanceVisitor.isOnDrawMethod(evaluator, node) || PerformanceVisitor.isOnMeasureMethod(evaluator, node) || PerformanceVisitor.isOnLayoutMethod(evaluator, node) || PerformanceVisitor.isLayoutMethod(evaluator, node);
        }

        private static boolean isOnDrawMethod(JavaEvaluator evaluator, PsiMethod node) {
            return JavaPerformanceDetector.ON_DRAW.equals(node.getName()) && evaluator.parametersMatch(node, JavaPerformanceDetector.CLASS_CANVAS);
        }

        private static boolean isOnLayoutMethod(JavaEvaluator evaluator, PsiMethod node) {
            return JavaPerformanceDetector.ON_LAYOUT.equals(node.getName()) && evaluator.parametersMatch(node, "boolean", "int", "int", "int", "int");
        }

        private static boolean isOnMeasureMethod(JavaEvaluator evaluator, PsiMethod node) {
            return JavaPerformanceDetector.ON_MEASURE.equals(node.getName()) && evaluator.parametersMatch(node, "int", "int");
        }

        private static boolean isLayoutMethod(JavaEvaluator evaluator, PsiMethod node) {
            return JavaPerformanceDetector.LAYOUT.equals(node.getName()) && evaluator.parametersMatch(node, "int", "int", "int", "int");
        }

        private void checkHashMap(PsiNewExpression node, PsiJavaCodeReferenceElement reference) {
            PsiType[] types = reference.getTypeParameters();
            if (types.length == 2) {
                PsiType first = types[0];
                String typeName = first.getCanonicalText();
                int minSdk = this.mContext.getMainProject().getMinSdk();
                if ("java.lang.Integer".equals(typeName) || "java.lang.Byte".equals(typeName)) {
                    String valueType = types[1].getCanonicalText();
                    if (valueType.equals("java.lang.Integer")) {
                        this.mContext.report(USE_SPARSE_ARRAY, (PsiElement)node, this.mContext.getLocation((PsiElement)node), "Use new `SparseIntArray(...)` instead for better performance");
                    } else if (valueType.equals("java.lang.Long") && minSdk >= 18) {
                        this.mContext.report(USE_SPARSE_ARRAY, (PsiElement)node, this.mContext.getLocation((PsiElement)node), "Use `new SparseLongArray(...)` instead for better performance");
                    } else if (valueType.equals("java.lang.Boolean")) {
                        this.mContext.report(USE_SPARSE_ARRAY, (PsiElement)node, this.mContext.getLocation((PsiElement)node), "Use `new SparseBooleanArray(...)` instead for better performance");
                    } else {
                        this.mContext.report(USE_SPARSE_ARRAY, (PsiElement)node, this.mContext.getLocation((PsiElement)node), String.format("Use `new SparseArray<%1$s>(...)` instead for better performance", valueType.substring(valueType.lastIndexOf(46) + 1)));
                    }
                } else if ("java.lang.Long".equals(typeName) && (minSdk >= 16 || Boolean.TRUE == this.mContext.getMainProject().dependsOn("com.android.support:support-v4"))) {
                    boolean useBuiltin = minSdk >= 16;
                    String message = useBuiltin ? "Use `new LongSparseArray(...)` instead for better performance" : "Use `new android.support.v4.util.LongSparseArray(...)` instead for better performance";
                    this.mContext.report(USE_SPARSE_ARRAY, (PsiElement)node, this.mContext.getLocation((PsiElement)node), message);
                }
            }
        }

        private void checkSparseArray(PsiNewExpression node, PsiJavaCodeReferenceElement reference) {
            PsiType[] types = reference.getTypeParameters();
            if (types.length == 1) {
                String valueType = types[0].getCanonicalText();
                if (valueType.equals("java.lang.Integer")) {
                    this.mContext.report(USE_SPARSE_ARRAY, (PsiElement)node, this.mContext.getLocation((PsiElement)node), "Use `new SparseIntArray(...)` instead for better performance");
                } else if (valueType.equals("java.lang.Boolean")) {
                    this.mContext.report(USE_SPARSE_ARRAY, (PsiElement)node, this.mContext.getLocation((PsiElement)node), "Use `new SparseBooleanArray(...)` instead for better performance");
                }
            }
        }
    }
}

